/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.file.transfer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FileTransferPacket(String transferPath, String fileName, boolean request, byte[] bytes) implements class_8710
{
    @ApiStatus.Internal
    public static final class_8710.class_9154<FileTransferPacket> PACKET_TYPE = new class_8710.class_9154(FrozenLibConstants.id("file_transfer"));
    @ApiStatus.Internal
    public static final class_9139<class_2540, FileTransferPacket> STREAM_CODEC = class_9139.method_56438(FileTransferPacket::write, FileTransferPacket::create);

    @ApiStatus.Internal
    @NotNull
    public static FileTransferPacket create(@NotNull class_2540 buf) {
        return new FileTransferPacket(buf.method_19772(), buf.method_19772(), buf.readBoolean(), buf.method_10795());
    }

    @NotNull
    public static FileTransferPacket create(String destPath, @NotNull File file) throws IOException {
        return new FileTransferPacket(destPath, file.getName(), false, FileTransferPacket.readFile(file));
    }

    @NotNull
    public static FileTransferPacket createRequest(String requestPath, String fileName) {
        return new FileTransferPacket(requestPath, fileName, true, new byte[0]);
    }

    @ApiStatus.Internal
    private static byte @Nullable [] readFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            fileInputStream.transferTo(byteArrayOutputStream);
            fileInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendToPlayer(File file, String destPath, class_3222 player) throws IOException {
        if (!FrozenLibConfig.FILE_TRANSFER_SERVER) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)FileTransferPacket.create(destPath, file));
    }

    @ApiStatus.Internal
    public void write(@NotNull class_2540 buf) {
        buf.method_10814(this.transferPath);
        buf.method_10814(this.fileName);
        buf.method_52964(this.request);
        buf.method_10813(this.bytes);
    }

    @ApiStatus.Internal
    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }
}

