/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance;

import java.nio.file.Path;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenBools;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.config.api.instance.ConfigModification;
import net.frozenblock.lib.config.api.registry.ConfigLoadEvent;
import net.frozenblock.lib.config.api.registry.ConfigSaveEvent;
import net.frozenblock.lib.config.api.sync.annotation.UnsyncableConfig;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class Config<T> {
    private final String modId;
    private final Path path;
    private final boolean supportsModification;
    private final Class<T> configClass;
    private T configInstance;
    private final T defaultInstance;
    private boolean synced = false;

    protected Config(String modId, Class<T> configClass, Path path, boolean supportsModification) {
        this.modId = modId;
        this.path = path;
        this.supportsModification = supportsModification;
        this.configClass = configClass;
        try {
            this.configInstance = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.defaultInstance = this.configInstance;
        }
        catch (Exception e) {
            throw new IllegalStateException("No default constructor for default config instance.", e);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Path makePath(String modId, String extension) {
        return Path.of("./config/" + modId + "." + extension, new String[0]);
    }

    public String modId() {
        return this.modId;
    }

    public Path path() {
        return this.path;
    }

    public boolean supportsModification() {
        return this.supportsModification;
    }

    public T config() {
        if (this.supportsModification()) {
            return ConfigModification.modifyConfig(this, this.instance(), false);
        }
        return this.instance();
    }

    public T configWithSync() {
        if (!this.supportsSync()) {
            String formatted = String.format("Config %s from %s", this.configClass().getSimpleName(), this.modId());
            FrozenLibLogUtils.logWarning(formatted + " does not support modification, returning unmodified instance.", FrozenLibLogUtils.UNSTABLE_LOGGING);
            return this.instance();
        }
        return ConfigModification.modifyConfig(this, this.instance(), true);
    }

    public boolean supportsSync() {
        return this.supportsModification() && !this.configClass().isAnnotationPresent(UnsyncableConfig.class);
    }

    public T instance() {
        return this.configInstance;
    }

    public void setConfig(T configInstance) {
        this.configInstance = configInstance;
    }

    public T defaultInstance() {
        return this.defaultInstance;
    }

    public Class<T> configClass() {
        return this.configClass;
    }

    public void onSync(T syncInstance) {
    }

    protected String formattedName() {
        return String.format("config %s from %s", this.configClass().getSimpleName(), this.modId());
    }

    protected abstract void onSave() throws Exception;

    protected abstract boolean onLoad() throws Exception;

    public final void save() {
        String formatted = this.formattedName();
        FrozenLibConstants.LOGGER.info("Saving {}", (Object)formatted);
        try {
            this.onSave();
            if (FrozenBools.isInitialized) {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    ConfigSyncPacket.trySendC2S(this);
                }
                this.invokeSaveEvents();
            }
        }
        catch (Exception e) {
            FrozenLibLogUtils.logError((Object)("Error while saving " + formatted), e);
        }
    }

    public final boolean load() {
        String formatted = this.formattedName();
        FrozenLibConstants.LOGGER.info("Loading {}", (Object)formatted);
        try {
            boolean loadVal = this.onLoad();
            if (FrozenBools.isInitialized) {
                this.invokeLoadEvents();
            }
            return loadVal;
        }
        catch (Exception e) {
            FrozenLibLogUtils.logError((Object)("Error while loading " + formatted), e);
            return false;
        }
    }

    private void invokeSaveEvents() {
        String formatted = this.formattedName();
        try {
            ((ConfigSaveEvent)ConfigSaveEvent.EVENT.invoker()).onSave(this);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ((ConfigSaveEvent.Client)ConfigSaveEvent.Client.EVENT.invoker()).onSave(this);
            }
        }
        catch (Exception e) {
            FrozenLibLogUtils.logError((Object)("Error in config save events for " + formatted), e);
        }
    }

    private void invokeLoadEvents() {
        String formatted = this.formattedName();
        try {
            ((ConfigLoadEvent)ConfigLoadEvent.EVENT.invoker()).onLoad(this);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ((ConfigLoadEvent.Client)ConfigLoadEvent.Client.EVENT.invoker()).onLoad(this);
            }
        }
        catch (Exception e) {
            FrozenLibLogUtils.logError((Object)("Error in config load events for " + formatted), e);
        }
    }

    @Generated
    public boolean isSynced() {
        return this.synced;
    }

    @Generated
    public void setSynced(boolean synced) {
        this.synced = synced;
    }
}

