/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.apache.commons.lang3.mutable.MutableInt;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;
import wraith.alloyforgery.recipe.CountedIngredient;
import wraith.alloyforgery.recipe.OutputData;

public record RawAlloyForgeRecipe(Map<class_1856, Integer> inputs, OutputData outputData, int minForgeTier, int requiredFuel, Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> overrideData) {
    private static final List<AlloyForgeRecipe> ingredientInputFormatIssues = new ArrayList<AlloyForgeRecipe>();
    private static final Hash.Strategy<class_1856> INGREDIENT_STRATEGY = new Hash.Strategy<class_1856>(){

        public int hashCode(class_1856 o) {
            String stringData;
            if (o == null) {
                return 0;
            }
            try {
                stringData = ((JsonElement)class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)o).getOrThrow(IllegalStateException::new)).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return stringData.hashCode();
        }

        public boolean equals(class_1856 a, class_1856 b) {
            String stringDataB;
            String stringDataA;
            if (a == null || b == null) {
                return false;
            }
            try {
                stringDataA = ((JsonElement)class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)a).getOrThrow(IllegalStateException::new)).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                stringDataB = ((JsonElement)class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)b).getOrThrow(IllegalStateException::new)).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return stringDataA.equals(stringDataB);
        }
    };
    public static Endec<Map<class_1856, Integer>> INPUTS = CountedIngredient.ENDEC.listOf().xmap(list -> {
        Object2ObjectLinkedOpenCustomHashMap unprocessedData = new Object2ObjectLinkedOpenCustomHashMap(INGREDIENT_STRATEGY);
        for (CountedIngredient countedIngredient : list) {
            class_1856 ingredient2 = countedIngredient.ingredient();
            if (unprocessedData.containsKey((Object)ingredient2) && (AlloyForgery.CONFIG.strictRecipeChecks() || FabricLoader.getInstance().isDevelopmentEnvironment())) {
                String jsonData = class_1856.field_46095.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient2).result().map(JsonElement::toString).orElse("Error Unknown");
                throw new IllegalStateException("Duplicate Ingredient Entry! Merge all ingredients of [" + jsonData + "] into a single entry and add a count!");
            }
            ((MutableInt)unprocessedData.computeIfAbsent((Object)ingredient2, key -> new MutableInt(0))).add(countedIngredient.count());
        }
        LinkedHashMap data = new LinkedHashMap();
        unprocessedData.forEach((ingredient, mutableInt) -> data.put(ingredient, mutableInt.getValue()));
        return data;
    }, map -> map.entrySet().stream().map(entry -> new CountedIngredient((class_1856)entry.getKey(), (Integer)entry.getValue())).toList());
    public static Endec<AlloyForgeRecipe.PendingOverride> PENDING_OVERRIDE = StructEndecBuilder.of((StructField)MinecraftEndecs.ofRegistry((class_2378)class_7923.field_41178).optionalFieldOf("item", AlloyForgeRecipe.PendingOverride::item, () -> null), (StructField)MinecraftEndecs.ofRegistry((class_2378)class_7923.field_41178).optionalFieldOf("id", orderride -> null, () -> null), (StructField)Endec.INT.fieldOf("count", AlloyForgeRecipe.PendingOverride::count), (StructField)CodecUtils.toEndec((Codec)class_9326.field_49589).optionalFieldOf("components", AlloyForgeRecipe.PendingOverride::components, (Object)class_9326.field_49588), (item, item2, count, components) -> {
        if (item == null) {
            item = item2;
        }
        return new AlloyForgeRecipe.PendingOverride((class_1792)item, (int)count, (class_9326)components);
    });
    public static StructEndec<RawAlloyForgeRecipe> ENDEC = StructEndecBuilder.of((StructField)INPUTS.validate(ingredientToCount -> {
        if (ingredientToCount.isEmpty()) {
            throw new JsonSyntaxException("Inputs cannot be empty");
        }
        if (ingredientToCount.keySet().size() > 10) {
            throw new JsonSyntaxException("Recipe has more than 10 distinct input ingredients");
        }
        if (ingredientToCount.values().stream().mapToInt(integer -> integer).sum() > 640) {
            throw new JsonSyntaxException("Recipe exceeded maximum input item count of 640");
        }
    }).fieldOf("inputs", RawAlloyForgeRecipe::inputs), (StructField)OutputData.ENDEC.fieldOf("output", RawAlloyForgeRecipe::outputData), (StructField)Endec.INT.fieldOf("min_forge_tier", RawAlloyForgeRecipe::minForgeTier), (StructField)Endec.INT.fieldOf("fuel_per_tick", RawAlloyForgeRecipe::requiredFuel), (StructField)PENDING_OVERRIDE.mapOf().xmap(rawData -> {
        LinkedHashMap data = new LinkedHashMap();
        rawData.forEach((s, pendingOverride) -> data.put(AlloyForgeRecipe.OverrideRange.fromString(s), pendingOverride));
        return data;
    }, data -> {
        LinkedHashMap rawData = new LinkedHashMap();
        data.forEach((range, pendingOverride) -> rawData.put(range.toString(), pendingOverride));
        return rawData;
    }).optionalFieldOf("overrides", RawAlloyForgeRecipe::overrideData, HashMap::new), RawAlloyForgeRecipe::new);

    public class_3545<class_1799, ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>> finalOutputData(Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> overridesBuilder) {
        if (this.outputData.outputItem() == null) {
            return new class_3545((Object)class_1799.field_8037, (Object)ImmutableMap.of());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        class_1799 outputStack = new class_1799((class_1935)this.outputData.outputItem(), this.outputData.count().intValue());
        for (Map.Entry<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> entry : overridesBuilder.entrySet()) {
            class_1799 stack;
            if (entry.getValue().isCountOnly()) {
                stack = outputStack.method_7972();
                stack.method_7939(entry.getValue().count());
            } else {
                stack = entry.getValue().stack();
            }
            if (!entry.getValue().components().method_57848()) {
                stack.method_59692(entry.getValue().components());
            }
            builder.put((Object)entry.getKey(), (Object)stack);
        }
        return new class_3545((Object)outputStack, (Object)builder.build());
    }

    public AlloyForgeRecipe generateRecipe() {
        return this.generateRecipe(false);
    }

    public AlloyForgeRecipe generateRecipe(boolean isDataGenerated) {
        class_3545<class_1799, ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>> outputData = this.finalOutputData(this.overrideData);
        AlloyForgeRecipe recipe = new AlloyForgeRecipe(Optional.of(this), this.inputs, (class_1799)outputData.method_15442(), this.minForgeTier, this.requiredFuel, (Map)outputData.method_15441());
        if (!isDataGenerated && this.outputData.prioritisedOutput()) {
            AlloyForgeRecipe.PENDING_RECIPES.put(recipe, new AlloyForgeRecipe.PendingRecipeData((class_3545<class_6862<class_1792>, Integer>)new class_3545(this.outputData.defaultTag(), (Object)this.outputData.count()), this.overrideData));
        }
        return recipe;
    }
}

