/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.foodoverhaul.mixin.entity.player;

import com.github.theredbrain.foodoverhaul.FoodOverhaul;
import com.github.theredbrain.foodoverhaul.effect.FoodStatusEffect;
import com.github.theredbrain.foodoverhaul.effect.RemoveFoodStatusEffect;
import com.github.theredbrain.foodoverhaul.entity.player.DuckPlayerEntityMixin;
import java.util.Collection;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements DuckPlayerEntityMixin {
    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract class_1796 method_7357();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void foodoverhaul$createPlayerAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26868(FoodOverhaul.MAX_FOOD_EFFECTS, 3.0);
    }

    @Inject(method={"eatFood"}, at={@At(value="RETURN")})
    public void foodoverhaul$eatFood(class_1937 world, class_1799 stack, class_4174 foodComponent, CallbackInfoReturnable<class_1799> cir) {
        this.method_7357().method_7906(stack.method_7909(), ((Integer)FoodOverhaul.SERVER_CONFIG.item_cooldown_after_eating.get()).intValue());
    }

    @Override
    @Unique
    public boolean foodoverhaul$canConsumeItem(class_1799 itemStack) {
        class_4174 foodComponent = (class_4174)itemStack.method_57824(class_9334.field_50075);
        if (foodComponent != null) {
            for (class_4174.class_9423 statusEffectEntry : foodComponent.comp_2495()) {
                if (this.method_37908().field_9236) continue;
                return this.foodoverhaul$tryEatOverhauledFood(statusEffectEntry.comp_2496());
            }
        }
        return false;
    }

    @Override
    @Unique
    public boolean foodoverhaul$tryEatOverhauledFood(class_1293 statusEffectInstance) {
        if (this.method_6026().isEmpty() || statusEffectInstance.method_5579().comp_349() instanceof RemoveFoodStatusEffect) {
            return true;
        }
        if (statusEffectInstance.method_5579().comp_349() instanceof FoodStatusEffect) {
            boolean bl;
            int currentEatenFoods = 0;
            Collection collection = this.method_6026();
            for (class_1293 currentEffect : collection) {
                if (currentEffect.method_5579() == statusEffectInstance.method_5579()) {
                    if (currentEffect.method_48557(((Integer)FoodOverhaul.SERVER_CONFIG.food_effect_duration_threshold_to_allow_eating.get()).intValue())) {
                        return true;
                    }
                    this.method_7353((class_2561)class_2561.method_43471((String)"hud.message.foodEatenAlready").method_10852((class_2561)class_2561.method_43471((String)currentEffect.method_5586())), true);
                    return false;
                }
                if (!(currentEffect.method_5579().comp_349() instanceof FoodStatusEffect)) continue;
                ++currentEatenFoods;
            }
            boolean bl2 = bl = (float)currentEatenFoods < this.foodoverhaul$getMaxFoodEffects();
            if (!bl) {
                this.method_7353((class_2561)class_2561.method_43471((String)"hud.message.maxFoodEaten"), true);
            }
            return bl;
        }
        return true;
    }

    @Override
    public float foodoverhaul$getMaxFoodEffects() {
        return (float)this.method_45325(FoodOverhaul.MAX_FOOD_EFFECTS);
    }
}

