/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.lexer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openzen.zenscript.lexer.CompiledDFA;

public class DFA<T> {
    public static final int NOFINAL = Integer.MIN_VALUE;
    private final Class<T> tokenClass;
    private DFAState<T> initial;

    public DFA(Class<T> tokenClass, DFAState<T> initial) {
        this.tokenClass = tokenClass;
        this.initial = initial;
    }

    public CompiledDFA<T> compile() {
        ArrayList nodeList = new ArrayList();
        HashMap nodes = new HashMap();
        nodes.put(this.initial, 0);
        nodeList.add(this.initial);
        int counter = 1;
        LinkedList todo = new LinkedList();
        todo.add(this.initial);
        while (!todo.isEmpty()) {
            DFAState current = (DFAState)todo.poll();
            for (int k : current.transitions.keySet()) {
                DFAState dFAState = current.transitions.get(k);
                if (nodes.containsKey(dFAState)) continue;
                todo.add(dFAState);
                nodes.put(dFAState, counter++);
                nodeList.add(dFAState);
            }
        }
        HashMap[] transitions = new HashMap[counter];
        Object[] finals2 = (Object[])Array.newInstance(this.tokenClass, counter);
        for (DFAState dFAState : nodeList) {
            int index = (Integer)nodes.get(dFAState);
            finals2[index] = dFAState.finalCode;
            transitions[index] = new HashMap();
            for (int k : dFAState.transitions.keySet()) {
                DFAState next = dFAState.transitions.get(k);
                transitions[index].put(k, (Integer)nodes.get(next));
            }
        }
        return new CompiledDFA<Object>(transitions, finals2);
    }

    public DFA<T> optimize() {
        int i;
        boolean changed;
        int i2;
        CompiledDFA<T> compiled = this.compile();
        Map<Integer, Integer>[] transitions = compiled.transitions;
        int size = transitions.length;
        HashSet<Integer> alphabet = new HashSet<Integer>();
        for (int i3 = 0; i3 < size; ++i3) {
            for (int k : transitions[i3].keySet()) {
                alphabet.add(k);
            }
        }
        boolean[][] distinguishable = new boolean[size + 1][size + 1];
        for (i2 = 0; i2 < size; ++i2) {
            for (int j = 0; j < size; ++j) {
                distinguishable[i2][j] = compiled.finals[i2] != compiled.finals[j];
            }
        }
        for (i2 = 0; i2 < size; ++i2) {
            distinguishable[i2][size] = true;
            distinguishable[size][i2] = true;
        }
        do {
            changed = false;
            Iterator ita = alphabet.iterator();
            while (ita.hasNext()) {
                int x = (Integer)ita.next();
                for (int i4 = 0; i4 < size; ++i4) {
                    int ti = transitions[i4].containsKey(x) ? transitions[i4].get(x) : size;
                    for (int j = 0; j < size; ++j) {
                        int tj;
                        if (distinguishable[i4][j]) continue;
                        int n = tj = transitions[j].containsKey(x) ? transitions[j].get(x) : size;
                        if (!distinguishable[ti][tj]) continue;
                        distinguishable[i4][j] = true;
                        changed = true;
                    }
                }
            }
        } while (changed);
        HashMap nodeMap = new HashMap();
        block9: for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (distinguishable[i][j] || !nodeMap.containsKey(j)) continue;
                nodeMap.put(i, (DFAState)nodeMap.get(j));
                if (compiled.finals[i] == null || ((DFAState)nodeMap.get(j)).getFinal() == null || ((DFAState)nodeMap.get(j)).getFinal() == compiled.finals[i]) continue block9;
                throw new RuntimeException("Eh?");
            }
            DFAState node = new DFAState();
            node.setFinal(compiled.finals[i]);
            nodeMap.put(i, node);
        }
        for (i = 0; i < compiled.transitions.length; ++i) {
            for (int k : transitions[i].keySet()) {
                ((DFAState)nodeMap.get(i)).addTransition(k, (DFAState)nodeMap.get(transitions[i].get(k)));
            }
        }
        DFA<T> result = new DFA<T>(this.tokenClass, (DFAState)nodeMap.get(0));
        return result;
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        CompiledDFA<T> dfs = this.compile();
        for (i = 0; i < dfs.transitions.length; ++i) {
            Map<Integer, Integer> map = dfs.transitions[i];
            for (int v : map.keySet()) {
                result.append("edge(");
                result.append(i);
                result.append(", ");
                result.append(v);
                result.append("): ");
                result.append(map.get(v));
                result.append("\r\n");
            }
        }
        for (i = 0; i < dfs.finals.length; ++i) {
            if (dfs.finals[i] == null) continue;
            result.append("final(");
            result.append(i);
            result.append("): ");
            result.append(dfs.finals[i]);
            result.append("\r\n");
        }
        return result.toString();
    }

    public static class DFAState<T> {
        private Map<Integer, DFAState<T>> transitions = new HashMap<Integer, DFAState<T>>();
        private T finalCode = null;

        public void addTransition(int label, DFAState<T> next) {
            this.transitions.put(label, next);
        }

        public T getFinal() {
            return this.finalCode;
        }

        public void setFinal(T finalCode) {
            this.finalCode = finalCode;
        }
    }
}

