/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.attribute.ItemAttributeModifierBase;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.ExpandEntity;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.crafttweaker.natives.world.ExpandBlockGetter;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public interface IEventHelper {
    public static final Map<class_3956<?>, List<Pair<IIngredient, Integer>>> BURN_TIMES = new HashMap();
    public static final Set<class_1657> BLOCK_INFO_PLAYERS = new HashSet<class_1657>();
    public static final Set<class_1657> ENTITY_INFO_PLAYERS = new HashSet<class_1657>();
    public static final Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> ATTRIBUTE_MODIFIERS = new HashMap<IIngredient, List<Consumer<ItemAttributeModifierBase>>>();

    default public void setBurnTime(IIngredient ingredient, int burnTime, class_3956<?> type) {
        this.getBurnTimes().computeIfAbsent(type, recipeType -> new ArrayList()).add(Pair.of((Object)ingredient, (Object)burnTime));
    }

    public int getBurnTime(IItemStack var1);

    default public Map<class_3956<?>, List<Pair<IIngredient, Integer>>> getBurnTimes() {
        return BURN_TIMES;
    }

    default public Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> getAttributeModifiers() {
        return ATTRIBUTE_MODIFIERS;
    }

    default public boolean onBlockInteract(class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1937 world = player.method_37908();
        class_2338 pos = hitResult.method_17777();
        if (BLOCK_INFO_PLAYERS.contains(player)) {
            if (!world.method_8608() && hand == class_1268.field_5808) {
                IData tileData;
                class_2680 state = world.method_8320(pos);
                IEventHelper.sendAndLog(player, class_2561.method_43469((String)"crafttweaker.command.info.block.name", (Object[])new Object[]{class_7923.field_41175.method_10221((Object)state.method_26204()).toString()}));
                String blockCS = ExpandBlock.getCommandString(state.method_26204());
                String blockStateCS = ExpandBlockState.getCommandString(state);
                CommandUtilities.sendCopying(player.method_5671(), class_2561.method_43471((String)"crafttweaker.command.misc.block").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)blockCS).method_27692(class_124.field_1060)), blockCS);
                CommandUtilities.sendCopying(player.method_5671(), class_2561.method_43471((String)"crafttweaker.command.misc.blockstate").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)blockStateCS).method_27692(class_124.field_1060)), blockStateCS);
                if (!state.method_28501().isEmpty()) {
                    IEventHelper.sendAndLog(player, class_2561.method_43471((String)"crafttweaker.command.info.block.properties"));
                    state.method_28501().forEach(property -> IEventHelper.sendAndLog(player, class_2561.method_43470((String)("    " + property.method_11899())).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)state.method_11654(property).toString()).method_27692(class_124.field_1075))));
                }
                if (!(tileData = ExpandBlockGetter.getBlockEntityData((class_1922)world, pos)).isEmpty()) {
                    IEventHelper.sendAndLog(player, class_2561.method_43469((String)"crafttweaker.command.info.block.entity.data", (Object[])new Object[]{tileData.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    default public boolean onEntityInteract(class_1657 player, class_1268 hand, class_1297 target) {
        class_1937 world = player.method_37908();
        if (ENTITY_INFO_PLAYERS.contains(player)) {
            if (!world.method_8608() && hand == class_1268.field_5808) {
                IEventHelper.sendAndLog(player, class_2561.method_43469((String)"crafttweaker.command.info.entity.name", (Object[])new Object[]{ExpandEntity.getName(target)}));
                IEventHelper.sendAndLog(player, class_2561.method_43469((String)"crafttweaker.command.info.entity.type.bracket", (Object[])new Object[]{ExpandEntityType.getCommandString((class_1299<class_1297>)((class_1299)GenericUtil.uncheck(target.method_5864())))}));
                MapData data = ExpandEntity.getData(target);
                if (!data.isEmpty()) {
                    IEventHelper.sendAndLog(player, class_2561.method_43469((String)"crafttweaker.command.info.entity.data", (Object[])new Object[]{data.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    private static void sendAndLog(class_1657 player, class_5250 component) {
        ExpandPlayer.sendMessage(player, (class_2561)component);
        CommonLoggers.api().info(component.getString());
    }
}

