/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.gametest.logging.appender;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_4512;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="PlayerAppender", category="Core", elementType="appender")
public class GameTestLoggerAppender
extends AbstractAppender {
    private final List<LogMessage> messages = new LinkedList<LogMessage>();

    protected GameTestLoggerAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        String originalMessage = ((PatternLayout)this.getLayout()).toSerializable(event);
        String message = originalMessage.replaceAll(System.lineSeparator(), "");
        this.messages.add(new LogMessage(message, originalMessage, event.getLevel()));
    }

    @PluginFactory
    public static GameTestLoggerAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @Nullable @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new GameTestLoggerAppender(name, filter, layout, true, Property.EMPTY_ARRAY);
    }

    public void claim() {
        this.messages.clear();
    }

    public QueryableLog query() {
        return new QueryableLog(List.copyOf(this.messages));
    }

    private record LogMessage(String message, String actualMessage, Level level) {
        static LogMessage mock(String message) {
            return new LogMessage(message, message, Level.INFO);
        }
    }

    public static final class QueryableLog {
        private final List<LogMessage> log;

        QueryableLog(List<LogMessage> log) {
            this.log = log;
        }

        public static QueryableLog mock(List<String> mockMessages) {
            return new QueryableLog(Lists.transform(mockMessages, LogMessage::mock));
        }

        public void assertNoErrors() {
            if (this.log.stream().anyMatch(logMessage -> logMessage.level() == Level.ERROR)) {
                this.dump();
                throw new class_4512("Expected no errors but errors were found!");
            }
        }

        public void assertNoWarnings() {
            if (this.log.stream().anyMatch(logMessage -> logMessage.level() == Level.WARN)) {
                this.dump();
                throw new class_4512("Expected no warnings but errors were found!");
            }
        }

        public void assertOutput(int index, String message) {
            this.assertOutputFor(index, () -> "equal '" + message + "'", Objects.requireNonNull(message)::equals);
        }

        public void assertOutputContains(int index, String message) {
            Objects.requireNonNull(message);
            this.assertOutputFor(index, () -> "contain '" + message + "'", it -> it.contains(message));
        }

        public void dump() {
            for (int i = 0; i < this.log.size(); ++i) {
                CraftTweakerCommon.logger().info("{}: {} '{}'", (Object)i, (Object)this.log.get((int)i).level, (Object)this.log.get((int)i).actualMessage);
            }
        }

        private void assertOutputFor(int index, Supplier<String> what, Predicate<String> checker) {
            if (index >= this.log.size()) {
                throw new class_4512("Expected line " + index + " to " + what.get() + ", but the line does not exist");
            }
            LogMessage logMessage = this.log.get(index);
            if (logMessage == null) {
                throw new class_4512("Expected line " + index + " to " + what.get() + ", but the line was logged as 'null': this is critical!");
            }
            String message = logMessage.message();
            if (!checker.test(message)) {
                throw new class_4512("Expected line " + index + " to " + what.get() + ", but found '" + message + "'");
            }
        }
    }
}

