/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket.custom;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ICraftTweakerRegistry;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.manager.RecipeManagerWrapper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.impl.script.ScriptRecipeType;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_9695;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionCast;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;
import org.openzen.zenscript.parser.expression.ParsedExpressionVariable;
import org.openzen.zenscript.parser.type.IParsedType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.bracket.RecipeTypeBracketHandler")
public class RecipeTypeBracketHandler
implements BracketExpressionParser {
    private static final Set<Supplier<class_3956<?>>> FILTERED_TYPES = ImmutableSet.of((Object)Suppliers.memoize(() -> ScriptRecipeType.INSTANCE));
    private static final Object LOCK = new Object();
    private static final Map<class_3956<class_1860<?>>, IRecipeManager<class_1860<?>>> registeredTypes = new HashMap();
    private static final Map<Class<? extends IRecipeManager<class_1860<? extends class_9695>>>, IRecipeManager<class_1860<?>>> managerInstances = new HashMap();
    private static volatile Runnable enqueuedRegistration = null;

    public RecipeTypeBracketHandler() {
        enqueuedRegistration = () -> {
            ICraftTweakerRegistry registry = CraftTweakerAPI.getRegistry();
            registeredTypes.clear();
            registry.getAllLoaders().stream().map(it -> CraftTweakerAPI.getRegistry().getZenClassRegistry().getImplementationsOf((IScriptLoader)it, IRecipeManager.class)).flatMap(Collection::stream).filter(it -> RecipeManagerWrapper.class != it).map(GenericUtil::uncheck).forEach(this::registerRecipeManager);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IRecipeManager<class_1860<? extends class_9695>>> getManagerInstances() {
        if (enqueuedRegistration != null) {
            Object object = LOCK;
            synchronized (object) {
                if (enqueuedRegistration != null) {
                    enqueuedRegistration.run();
                    enqueuedRegistration = null;
                }
            }
        }
        return managerInstances.values();
    }

    public static IRecipeManager<class_1860<?>> getOrDefault(class_2960 location) {
        return RecipeTypeBracketHandler.getOrDefault(RecipeTypeBracketHandler.lookup(location));
    }

    public static IRecipeManager<class_1860<?>> getOrDefault(class_3956 type) {
        if (FILTERED_TYPES.stream().anyMatch(it -> type == it.get())) {
            return null;
        }
        return RecipeTypeBracketHandler.registeredTypes().computeIfAbsent(type, RecipeManagerWrapper::makeOrNull);
    }

    @ZenCodeType.Method
    public static <T extends IRecipeManager<?>> T getRecipeManager(String location) {
        class_3956<class_1860<?>> recipeType = RecipeTypeBracketHandler.lookup(class_2960.method_60654((String)location));
        if (recipeType == null) {
            throw new IllegalArgumentException("Unknown recipe type: " + location);
        }
        return (T)RecipeTypeBracketHandler.registeredTypes().get(recipeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<class_3956<class_1860<?>>, IRecipeManager<class_1860<?>>> registeredTypes() {
        if (enqueuedRegistration != null) {
            Object object = LOCK;
            synchronized (object) {
                if (enqueuedRegistration != null) {
                    enqueuedRegistration.run();
                    enqueuedRegistration = null;
                }
            }
        }
        return registeredTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class<? extends IRecipeManager<class_1860<?>>>, IRecipeManager<class_1860<?>>> managerInstances() {
        if (enqueuedRegistration != null) {
            Object object = LOCK;
            synchronized (object) {
                if (enqueuedRegistration != null) {
                    enqueuedRegistration.run();
                    enqueuedRegistration = null;
                }
            }
        }
        return managerInstances;
    }

    private void registerRecipeManager(Class<? extends IRecipeManager<class_1860<?>>> managerClass) {
        if (managerInstances.containsKey(managerClass)) {
            IRecipeManager<class_1860<?>> manager = managerInstances.get(managerClass);
            this.registerInstance(manager);
            return;
        }
        IRecipeManager<class_1860<?>> manager = InstantiationUtil.getOrCreateInstance(managerClass);
        if (manager == null) {
            CommonLoggers.zenCode().error("Could not add RecipeManager for {}, please report to the author", managerClass);
            return;
        }
        managerInstances.put(managerClass, manager);
        this.registerInstance(manager);
    }

    private void registerInstance(IRecipeManager<class_1860<?>> manager) {
        class_2960 bracketResourceLocation = manager.getBracketResourceLocation();
        Class<?> managerClass = manager.getClass();
        if (managerClass.getAnnotation(ZenCodeType.Name.class) == null) {
            String canonicalName = managerClass.getCanonicalName();
            CommonLoggers.zenCode().warn("No Name Annotation found on manager '{}', it will not be registered!", (Object)canonicalName);
            return;
        }
        registeredTypes.put(RecipeTypeBracketHandler.lookup(bracketResourceLocation), manager);
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String name = ParseUtil.readBracketContent(position, tokens);
        class_2960 resourceLocation = class_2960.method_12829((String)name);
        if (resourceLocation == null) {
            throw new ParseException(position, "Invalid ResourceLocation, expected: <recipetype:modid:location>");
        }
        if (RecipeTypeBracketHandler.registeredTypes().containsKey(RecipeTypeBracketHandler.lookup(resourceLocation))) {
            return this.getCall(name, RecipeTypeBracketHandler.registeredTypes().get(RecipeTypeBracketHandler.lookup(resourceLocation)), position);
        }
        if (class_7923.field_41188.method_10235().contains(resourceLocation)) {
            return this.getCallFallback(name, position);
        }
        throw new ParseException(position, String.format("Unknown RecipeType: <recipetype:%s>", name));
    }

    private ParsedExpression getCallFallback(String location, CodePosition position) {
        ParsedExpressionVariable crafttweaker = new ParsedExpressionVariable(position, "crafttweaker", null);
        ParsedExpressionMember api = new ParsedExpressionMember(position, crafttweaker, "api", Collections.emptyList());
        ParsedExpressionMember bracket = new ParsedExpressionMember(position, api, "bracket", Collections.emptyList());
        ParsedExpressionMember bracketHandlers = new ParsedExpressionMember(position, bracket, "BracketHandlers", null);
        ParsedExpressionMember getRecipeManager = new ParsedExpressionMember(position, bracketHandlers, "getRecipeManager", null);
        return new ParsedExpressionCall(position, getRecipeManager, new ParsedCallArguments(Collections.emptyList(), Collections.singletonList(new ParsedExpressionString(position, location, false))));
    }

    private ParsedExpression getCall(String location, IRecipeManager<?> manager, CodePosition position) throws ParseException {
        ParsedExpressionVariable crafttweaker = new ParsedExpressionVariable(position, "crafttweaker", null);
        ParsedExpressionMember api = new ParsedExpressionMember(position, crafttweaker, "api", Collections.emptyList());
        ParsedExpressionMember bracket = new ParsedExpressionMember(position, api, "bracket", Collections.emptyList());
        ParsedExpressionMember recipeTypeBracketHandler = new ParsedExpressionMember(position, bracket, "RecipeTypeBracketHandler", null);
        ParsedExpressionMember getRecipeManager = new ParsedExpressionMember(position, recipeTypeBracketHandler, "getRecipeManager", null);
        String nameContent = manager.getClass().getAnnotation(ZenCodeType.Name.class).value();
        IParsedType parsedType = ParseUtil.readParsedType(nameContent, position);
        ParsedCallArguments arguments = new ParsedCallArguments(Collections.singletonList(parsedType), Collections.singletonList(new ParsedExpressionString(position, location, false)));
        ParsedExpressionCall parsedExpressionCall = new ParsedExpressionCall(position, getRecipeManager, arguments);
        return new ParsedExpressionCast(position, parsedExpressionCall, parsedType, false);
    }

    private static class_3956<class_1860<?>> lookup(class_2960 location) {
        return (class_3956)GenericUtil.uncheck(class_7923.field_41188.method_10223(location));
    }

    public static Supplier<Stream<String>> getDumperData() {
        return () -> class_7923.field_41188.method_10235().stream().filter(rl -> !rl.equals((Object)ScriptRecipeType.INSTANCE.id())).map(rl -> String.format(Locale.ENGLISH, "<recipetype:%s>", rl));
    }
}

