/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_5864;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9331;
import net.minecraft.class_9766;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.bracket.BracketHandlers")
@Document(value="vanilla/api/BracketHandlers")
public class BracketHandlers {
    public static <T> T getRegistry(String tokens, class_5321<class_2378<T>> registry) {
        return BracketHandlers.getRegistry(tokens, registry, false);
    }

    public static <T> T getRegistry(String tokens, class_5321<class_2378<T>> registry, boolean includeTypeNamespace) {
        String[] split;
        String type;
        String string = type = includeTypeNamespace ? registry.method_29177().toString() : registry.method_29177().method_12832();
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("{} bracket <{}:{}> is not lowercase!", (Object)type, (Object)type, (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get " + type + " with name: <" + type + ":" + tokens + ">! Syntax is <" + type + ":modid:name>");
        }
        class_2960 key = class_2960.method_60655((String)split[0], (String)split[1]);
        return Services.REGISTRY.registryOrThrow(registry).method_17966(key).orElseThrow(() -> new IllegalArgumentException("Could not get " + type + " with name: <" + type + ":" + tokens + ">! " + type + " does not exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="attribute")
    public static class_1320 getAttribute(String tokens) {
        return (class_1320)BracketHandlers.getRegistry(tokens, class_7924.field_41251);
    }

    @ZenCodeType.Method
    @BracketResolver(value="block")
    public static class_2248 getBlock(String tokens) {
        return (class_2248)BracketHandlers.getRegistry(tokens, class_7924.field_41254);
    }

    @ZenCodeType.Method
    @BracketResolver(value="fluid")
    public static IFluidStack getFluidStack(String tokens) {
        return IFluidStack.of((class_3611)BracketHandlers.getRegistry(tokens, class_7924.field_41270), 1L);
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockstate")
    public static class_2680 getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("BlockState bracket <blockstate:{}> is not lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String blockName = split[0] + ":" + split[1];
            String properties = split.length > 2 ? split[2] : "";
            Optional found = class_7923.field_41175.method_17966(class_2960.method_60654((String)blockName));
            if (found.isEmpty()) {
                IllegalArgumentException t = new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not exist!");
                CommonLoggers.zenCode().error("Error creating BlockState!", (Throwable)t);
            } else {
                return BracketHandlers.getBlockState((class_2248)found.get(), properties);
            }
        }
        CommonLoggers.zenCode().error("Error creating BlockState!", (Throwable)new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"));
        return null;
    }

    public static class_2680 getBlockState(String name, String properties) {
        return BracketHandlers.getBlockState((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)name)), properties);
    }

    public static class_2680 getBlockState(class_2248 block, String properties) {
        class_2680 blockState = block.method_9564();
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CommonLoggers.zenCode().warn("Invalid blockstate property format '{}'. Using default property value.", (Object)propertyPair);
                    continue;
                }
                blockState = ExpandBlockState.withProperty(blockState, splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @BracketResolver(value="mobeffect")
    @ZenCodeType.Method
    public static class_1291 getMobEffect(String tokens) {
        return (class_1291)BracketHandlers.getRegistry(tokens, class_7924.field_41208);
    }

    @ZenCodeType.Method
    @BracketResolver(value="enchantment")
    public static class_1887 getEnchantment(String tokens) {
        return (class_1887)BracketHandlers.getRegistry(tokens, class_7924.field_41265);
    }

    @ZenCodeType.Method
    @BracketResolver(value="entitytype")
    public static class_1299<class_1297> getEntityType(String tokens) {
        return (class_1299)GenericUtil.uncheck(BracketHandlers.getRegistry(tokens, class_7924.field_41266));
    }

    @BracketResolver(value="item")
    @ZenCodeType.Method
    public static IItemStack getItem(String tokens) {
        return IItemStack.of(new class_1799((class_1935)BracketHandlers.getRegistry(tokens, class_7924.field_41197)));
    }

    @BracketResolver(value="potion")
    @ZenCodeType.Method
    public static class_1842 getPotion(String tokens) {
        return (class_1842)BracketHandlers.getRegistry(tokens, class_7924.field_41215);
    }

    @ZenCodeType.Method
    public static IRecipeManager<?> getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("RecipeType bracket <recipetype:{}> is not lower-cased!", (Object)tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        class_2960 key = class_2960.method_60654((String)tokens);
        IRecipeManager<class_1860<?>> result = RecipeTypeBracketHandler.getOrDefault(key);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not exist!");
    }

    @ZenCodeType.Method
    @BracketResolver(value="profession")
    public static class_3852 getProfession(String tokens) {
        return (class_3852)BracketHandlers.getRegistry(tokens, class_7924.field_41234);
    }

    @ZenCodeType.Method
    @BracketResolver(value="soundevent")
    public static class_3414 getSoundEvent(String tokens) {
        return (class_3414)BracketHandlers.getRegistry(tokens, class_7924.field_41225);
    }

    @ZenCodeType.Method
    @BracketResolver(value="targetingstrategy")
    public static ITargetingStrategy getTargetingStrategy(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Targeting strategy bracket <targetingstrategy:{}> is not lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get targeting strategy with <targetingstrategy:" + tokens + ">: syntax is <targetingstrategy:modid:name>");
        }
        class_2960 key = class_2960.method_60655((String)split[0], (String)split[1]);
        return ITargetingStrategy.find(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="villagertype")
    public static class_3854 getVillagerType(String tokens) {
        return (class_3854)BracketHandlers.getRegistry(tokens, class_7924.field_41235);
    }

    @ZenCodeType.Method
    @BracketResolver(value="componenttype")
    public static class_9331 getComponentType(String tokens) {
        return (class_9331)BracketHandlers.getRegistry(tokens, class_7924.field_49659);
    }

    @ZenCodeType.Method
    @BracketResolver(value="bannerpattern")
    public static class_2582 getBannerPattern(String tokens) {
        return (class_2582)BracketHandlers.getRegistry(tokens, class_7924.field_41252);
    }

    @ZenCodeType.Method
    @BracketResolver(value="instrument")
    public static class_7444 getInstrument(String tokens) {
        return (class_7444)BracketHandlers.getRegistry(tokens, class_7924.field_41275);
    }

    @ZenCodeType.Method
    @BracketResolver(value="trimpattern")
    public static class_8056 getTrimPattern(String tokens) {
        return (class_8056)BracketHandlers.getRegistry(tokens, class_7924.field_42082);
    }

    @ZenCodeType.Method
    @BracketResolver(value="trimmaterial")
    public static class_8054 getTrimMaterial(String tokens) {
        class_5864 registry = (class_5864)BracketHandlers.getRegistry(tokens, class_7924.field_41269);
        return (class_8054)BracketHandlers.getRegistry(tokens, class_7924.field_42083);
    }

    @ZenCodeType.Method
    @BracketResolver(value="decoratedpotpattern")
    public static class_9766 getDecoratedPotPattern(String tokens) {
        return (class_9766)BracketHandlers.getRegistry(tokens, class_7924.field_42941);
    }
}

