/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.guildmaster.item;

import com.cleannrooster.guildmaster.client.gui.quests.OrbshapingScreen;
import com.cleannrooster.guildmaster.network.Packets;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class EnchantOrb
extends class_1792 {
    public static List<OrbType> types = new ArrayList<OrbType>(List.of(OrbType.redeemer, OrbType.crusader, OrbType.warlord, OrbType.hunter));

    public EnchantOrb(class_1792.class_1793 settings) {
        super(settings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Environment(value=EnvType.CLIENT)
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715() && world instanceof class_638) {
            class_638 clientWorld = (class_638)world;
            if (hand.equals((Object)class_1268.field_5808)) {
                if (user.field_7520 < 3) return super.method_7836(world, user, hand);
                ClientPlayNetworking.send((class_8710)new Packets.SetEnchant());
                return class_1271.method_29237((Object)stack, (boolean)true);
            }
        }
        if (!(world instanceof class_638)) return super.method_7836(world, user, hand);
        class_638 clientWorld = (class_638)world;
        if (!hand.equals((Object)class_1268.field_5808) || EnchantOrb.getOrbType(stack) != null && EnchantOrb.getEnchantType(stack) != null) return super.method_7836(world, user, hand);
        class_310.method_1551().method_1507((class_437)new OrbshapingScreen(user.method_5998(hand)));
        return class_1271.method_29237((Object)stack, (boolean)true);
    }

    public static void setOrbType(class_1799 orb, OrbType orbType) {
        String string = orbType.name();
        class_2487 component = ((class_9279)orb.method_57353().method_57830(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
        component.method_10582("orbType", string);
        orb.method_57368(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)component), UnaryOperator.identity());
    }

    @Nullable
    public static OrbType getOrbType(class_1799 stack) {
        class_2487 compound = ((class_9279)stack.method_57353().method_57830(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
        OrbType orbType = null;
        String nameString = compound == null ? null : compound.method_10558("orbType");
        for (OrbType type : types) {
            if (!type.name().equals(nameString)) continue;
            orbType = type;
            break;
        }
        return orbType;
    }

    private List<class_1889> generateEnchantments(class_1799 thisItem, int seed, class_5819 random, class_5455 registryManager, class_1799 stack, int level) {
        random.method_43052((long)seed);
        Optional optional = registryManager.method_30530(class_7924.field_41265).method_40266(class_9636.field_51547);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<class_1889> list = EnchantOrb.generateEnchantments(thisItem, random, stack, level, ((class_6885.class_6888)optional.get()).method_40239());
        if (stack.method_31574(class_1802.field_8529) && list.size() > 1) {
            list.remove(random.method_43048(list.size()));
        }
        return list;
    }

    public static List<class_1889> getPossibleEntries(class_1799 thisItem, int level, class_1799 stack, Stream<class_6880<class_1887>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        boolean bl = stack.method_31574(class_1802.field_8529);
        possibleEnchantments.filter(enchantment -> ((class_1887)enchantment.comp_349()).method_58444(stack) || bl).forEach(enchantmentx -> {
            class_1887 enchantment = (class_1887)enchantmentx.comp_349();
            for (int j = enchantment.method_8183(); j >= enchantment.method_8187(); --j) {
                if (level < enchantment.method_8182(j) || level > enchantment.method_20742(j)) continue;
                list.add(new class_1889(enchantmentx, j));
                break;
            }
        });
        return list;
    }

    public static List<class_1889> generateEnchantments(class_1799 thisItem, class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        class_1792 item = stack.method_7909();
        int i = item.method_7837();
        if (i <= 0) {
            return list;
        }
        level += 1 + random.method_43048(i / 4 + 1) + random.method_43048(i / 4 + 1);
        float f = (random.method_43057() + random.method_43057() - 1.0f) * 0.15f;
        List<class_1889> list2 = EnchantOrb.getPossibleEntries(thisItem, level = class_3532.method_15340((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), stack, possibleEnchantments);
        if (!list2.isEmpty()) {
            Optional var10000 = class_6011.method_34986((class_5819)random, list2);
            Objects.requireNonNull(list);
            var10000.ifPresent(list::add);
            while (random.method_43048(50) <= level) {
                if (!list.isEmpty()) {
                    EnchantOrb.removeConflicts(list2, (class_1889)class_156.method_20793((List)list));
                }
                if (list2.isEmpty()) break;
                var10000 = class_6011.method_34986((class_5819)random, list2);
                Objects.requireNonNull(list);
                var10000.ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static void removeConflicts(List<class_1889> possibleEntries, class_1889 pickedEntry) {
        possibleEntries.removeIf(entry -> !class_1887.method_60033((class_6880)pickedEntry.field_9093, (class_6880)entry.field_9093));
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType.equals((Object)class_5536.field_27014) && !slot.method_7677().method_7960() && !stack.method_58657().method_57539().isEmpty()) {
            class_1799 finalStack = stack;
            int i = 0;
            for (class_6880 enchantmentLevelEntry : stack.method_58657().method_57534()) {
                if (slot.method_7677().method_58657().method_57534().size() < 3 && slot.method_7677().canBeEnchantedWith(enchantmentLevelEntry, EnchantingContext.ACCEPTABLE)) {
                    if (!slot.method_7677().method_58657().method_57534().contains(enchantmentLevelEntry) && !class_1890.method_8201((Collection)slot.method_7677().method_58657().method_57534(), (class_6880)enchantmentLevelEntry)) continue;
                    slot.method_7677().method_7978(enchantmentLevelEntry, finalStack.method_58657().method_57536(enchantmentLevelEntry));
                    ++i;
                    continue;
                }
                if (!slot.method_7677().method_58657().method_57534().contains(enchantmentLevelEntry)) continue;
                slot.method_7677().method_7978(enchantmentLevelEntry, finalStack.method_58657().method_57536(enchantmentLevelEntry));
                ++i;
            }
            if (i > 0) {
                stack.method_7934(1);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static class_1304 getEnchantType(class_1799 stack) {
        class_2487 compound = ((class_9279)stack.method_57353().method_57830(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
        class_1304 slot = null;
        String nameString = compound == null ? null : compound.method_10558("enchantType");
        for (class_1304 equipmentSlot : class_1304.values()) {
            if (!equipmentSlot.name().equals(nameString)) continue;
            slot = equipmentSlot;
            break;
        }
        return slot;
    }

    @Nullable
    public static void setEnchantType(class_1799 orb, class_1304 slot) {
        String string = slot.name();
        class_2487 component = ((class_9279)orb.method_57353().method_57830(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
        component.method_10582("enchantType", string);
        orb.method_57368(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)component), UnaryOperator.identity());
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2487 compound = ((class_9279)stack.method_57353().method_57830(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
        class_5250 text = super.method_7864(stack).method_27661();
        if (compound != null) {
            if (EnchantOrb.getOrbType(stack) != null) {
                text = class_2561.method_43471((String)("text.guildmaster." + EnchantOrb.getOrbType(stack).name())).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43471((String)"text.guildmaster.shaped_orb"));
            }
            if (EnchantOrb.getEnchantType(stack) != null) {
                text.method_10852((class_2561)class_2561.method_43471((String)"text.guildmaster.trans")).method_10852(class_2561.method_54155((Message)class_2561.method_43471((String)("text.guildmaster." + EnchantOrb.getEnchantType(stack).method_5923()))));
            }
        }
        return text;
    }

    public class_9323 method_57347() {
        return super.method_57347();
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        OrbType orbType = EnchantOrb.getOrbType(stack);
        class_1304 equipmentSlot = EnchantOrb.getEnchantType(stack);
        boolean orbMatch = false;
        boolean equipMatch = false;
        orbMatch = orbType != null ? ((class_1887)enchantment.comp_349()).comp_2687().comp_2506().method_40239().anyMatch(item -> item.method_40220(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"guildmaster", (String)orbType.name())))) : true;
        equipMatch = equipmentSlot != null ? ((class_1887)enchantment.comp_349()).method_60026(class_1304.valueOf((String)equipmentSlot.name())) : true;
        return equipMatch && orbMatch;
    }

    public int method_7837() {
        return 30;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"text.guildmaster.orb.use").method_27692(class_124.field_1080));
        if (EnchantOrb.getOrbType(stack) == null || EnchantOrb.getEnchantType(stack) == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.guildmaster.orb.rightclick").method_27692(class_124.field_1080));
        }
        if (!stack.method_58657().method_57534().isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.guildmaster.orb.drag").method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.guildmaster.orb.shiftrightclick").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"text.guildmaster.orb.exp").method_27692(class_124.field_1080));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public static enum OrbType {
        redeemer((class_2561)class_2561.method_43471((String)"guildmaster.type.redeemer")),
        hunter((class_2561)class_2561.method_43471((String)"guildmaster.type.hunter")),
        crusader((class_2561)class_2561.method_43471((String)"guildmaster.type.crusader")),
        warlord((class_2561)class_2561.method_43471((String)"guildmaster.type.warlord"));

        public final class_2561 textName;

        private OrbType(class_2561 text) {
            this.textName = text;
        }
    }
}

