/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;

public class BlackboardData
implements class_5632,
class_9299 {
    private static final class_2561 WAXED_TOOLTIP = class_2561.method_43471((String)"message.supplementaries.blackboard").method_27692(class_124.field_1080);
    private static final class_2561 GLOW_TOOLTIP = class_2561.method_43471((String)"message.supplementaries.glowing").method_27692(class_124.field_1080);
    private static final int SIZE = 16;
    private static final Codec<byte[][]> MATRIX_CODEC_OR_LEGACY = Codec.withAlternative(BlackboardData.byteMatrix(16), (Codec)Codec.LONG_STREAM.xmap(LongStream::toArray, Arrays::stream).xmap(BlackboardData::unpackPixels, BlackboardData::packPixels));
    public static final Codec<BlackboardData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATRIX_CODEC_OR_LEGACY.fieldOf("values").forGetter(v -> v.pixels), (App)Codec.BOOL.fieldOf("glow").forGetter(v -> v.glow), (App)Codec.BOOL.fieldOf("waxed").forGetter(v -> v.waxed)).apply((Applicative)instance, BlackboardData::new));
    public static final class_9139<class_9129, BlackboardData> STREAM_CODEC = class_9139.method_56436(BlackboardData.byteMatrixStream(16), data -> data.pixels, (class_9139)class_9135.field_48547, data -> data.glow, (class_9139)class_9135.field_48547, data -> data.waxed, BlackboardData::new);
    public static final BlackboardData EMPTY = new BlackboardData(new byte[16][16], false, false);
    private final byte[][] pixels;
    private final boolean glow;
    private final boolean waxed;
    private final int cachedHashCode;

    private static Codec<byte[][]> byteMatrix(int size) {
        return Codec.BYTE_BUFFER.xmap(buffer -> {
            byte[][] matrix = new byte[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    matrix[i][j] = buffer.get();
                }
            }
            return matrix;
        }, bytes -> {
            ByteBuffer buffer = ByteBuffer.allocate(size * size * 4);
            for (byte[] row : bytes) {
                buffer.put(row);
            }
            return buffer;
        });
    }

    private static class_9139<ByteBuf, byte[][]> byteMatrixStream(int size) {
        return class_9135.field_48987.method_56432(buffer -> {
            byte[][] matrix = new byte[size][size];
            for (int i = 0; i < size; ++i) {
                System.arraycopy(buffer, i * size, matrix[i], 0, size);
            }
            return matrix;
        }, bytes -> {
            byte[] flattened = new byte[size * size];
            for (int i = 0; i < size; ++i) {
                System.arraycopy(bytes[i], 0, flattened, i * size, size);
            }
            return flattened;
        });
    }

    public BlackboardData(byte[][] pixels, boolean glowing, boolean waxed) {
        this.pixels = pixels;
        this.glow = glowing;
        this.waxed = waxed;
        this.cachedHashCode = Objects.hash(Arrays.deepHashCode((Object[])pixels), this.glow, waxed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlackboardData)) {
            return false;
        }
        BlackboardData that = (BlackboardData)o;
        return this.glow == that.glow && this.waxed == that.waxed && Objects.deepEquals(this.pixels, that.pixels);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        if (this.waxed) {
            tooltipAdder.accept(WAXED_TOOLTIP);
        }
        if (this.glow) {
            tooltipAdder.accept(GLOW_TOOLTIP);
        }
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public boolean hasSamePixels(byte[][] pixels) {
        return Arrays.deepEquals((Object[])this.pixels, (Object[])pixels);
    }

    public boolean isEmpty() {
        byte[][] byArray = this.pixels;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] row;
            for (byte value : row = byArray[i]) {
                if (value == 0) continue;
                return false;
            }
        }
        return true;
    }

    public byte getPixel(int xx, int yy) {
        return this.pixels[xx][yy];
    }

    public byte[][] getPixelsUnsafe() {
        return this.pixels;
    }

    public BlackboardData makeCleared() {
        return new BlackboardData(new byte[16][16], this.glow, this.waxed);
    }

    public BlackboardData withPixel(int x, int y, byte b) {
        byte[][] newPixels = new byte[16][16];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(this.pixels[i], 0, newPixels[i], 0, 16);
        }
        newPixels[x][y] = b;
        return new BlackboardData(newPixels, this.glow, this.waxed);
    }

    public BlackboardData withWaxed(boolean b) {
        return new BlackboardData(this.pixels, this.glow, b);
    }

    public BlackboardData withGlow(boolean b) {
        return new BlackboardData(this.pixels, b, this.waxed);
    }

    public BlackboardData withPixels(byte[][] pixels) {
        return new BlackboardData(pixels, this.glow, this.waxed);
    }

    public static long[] packPixels(byte[][] pixels) {
        long[] packed = new long[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            long l = 0L;
            for (int j = 0; j < pixels[i].length; ++j) {
                l |= (long)(pixels[i][j] & 0xF) << j * 4;
            }
            packed[i] = l;
        }
        return packed;
    }

    public static byte[][] unpackPixels(long[] packed) {
        byte[][] bytes = new byte[16][16];
        for (int i = 0; i < packed.length; ++i) {
            for (int j = 0; j < 16; ++j) {
                bytes[i][j] = (byte)(packed[i] >> j * 4 & 0xFL);
            }
        }
        return bytes;
    }

    public static String packPixelsToStringWhiteOnly(long[] packed) {
        StringBuilder builder = new StringBuilder();
        for (long l : packed) {
            char c = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 4 * k & 1L);
                c = (char)(c | h << k);
            }
            char c1 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 16 + 4 * k & 1L);
                c1 = (char)(c1 | h << k);
            }
            char c2 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 32 + 4 * k & 1L);
                c2 = (char)(c2 | h << k);
            }
            char c3 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 48 + 4 * k & 1L);
                c3 = (char)(c3 | h << k);
            }
            builder.append(c).append(c1).append(c2).append(c3);
        }
        return builder.toString();
    }

    public static String packPixelsToString(long[] packed) {
        StringBuilder builder = new StringBuilder();
        for (long l : packed) {
            char c = '\u0000';
            for (int k = 0; k < 4; ++k) {
                int h = 0;
                for (int j = 0; j < 4; ++j) {
                    h = (byte)((long)h | l >> j + 4 * k & 1L);
                }
                c = (char)(c | h << k);
            }
            char c1 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                int h = 0;
                for (int j = 0; j < 4; ++j) {
                    h = (byte)((long)h | l >> j + 16 + 4 * k & 1L);
                }
                c1 = (char)(c1 | h << k);
            }
            char c2 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                int h = 0;
                for (int j = 0; j < 4; ++j) {
                    h = (byte)((long)h | l >> j + 32 + 4 * k & 1L);
                }
                c2 = (char)(c2 | h << k);
            }
            char c3 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                int h = 0;
                for (int j = 0; j < 4; ++j) {
                    h = (byte)((long)h | l >> j + 48 + 4 * k & 1L);
                }
                c3 = (char)(c3 | h << k);
            }
            builder.append(c).append(c1).append(c2).append(c3);
        }
        for (long l : packed) {
            char a = (char)(l & 0xFFFFL);
            char b = (char)(l >> 16 & 0xFFFFL);
            char c = (char)(l >> 32 & 0xFFFFL);
            char d = (char)(l >> 48 & 0xFFFFL);
            builder.append(a).append(b).append(c).append(d);
        }
        return builder.toString();
    }

    public static long[] unpackPixelsFromString(String packed) {
        long[] unpacked = BlackboardData.unpackPixelsFromStringWhiteOnly(packed);
        if (packed.length() <= 64) {
            return unpacked;
        }
        char[] chars = packed.substring(64).toCharArray();
        int j = 0;
        int i = 0;
        while (i + 3 < chars.length && j < 16) {
            unpacked[j] = unpacked[j] << 3 | unpacked[j] << 2 | unpacked[j] << 1;
            unpacked[j] = unpacked[j] & ((long)chars[i + 3] << 48 | (long)chars[i + 2] << 32 | (long)chars[i + 1] << 16 | (long)chars[i]);
            ++j;
            i += 4;
        }
        return unpacked;
    }

    public static long[] unpackPixelsFromStringWhiteOnly(String packed) {
        long[] unpacked = new long[16];
        char[] chars = packed.toCharArray();
        int j = 0;
        int i = 0;
        while (i + 3 < chars.length && j < 16) {
            long l = 0L;
            char c = chars[i];
            for (int k = 0; k < 4; ++k) {
                l |= (long)((c >> k & 1) << 4 * k);
            }
            char c2 = chars[i + 1];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c2 >> k & 1) << 16 + 4 * k;
            }
            char c3 = chars[i + 2];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c3 >> k & 1) << 32 + 4 * k;
            }
            char c4 = chars[i + 3];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c4 >> k & 1) << 48 + 4 * k;
            }
            unpacked[j] = l;
            ++j;
            i += 4;
        }
        return unpacked;
    }
}

