/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1747;
import net.minecraft.class_1776;
import net.minecraft.class_1778;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1823;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4537;
import net.minecraft.class_4587;
import net.minecraft.class_5633;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SlingshotItem
extends class_1811
implements IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeCharged) {
        int useDuration;
        float power;
        class_1657 player;
        class_1799 ammo;
        if (entity instanceof class_1657 && !(ammo = (player = (class_1657)entity).method_18808(stack)).method_7960() && (double)(power = SlingshotItem.getPowerForTime(useDuration = this.method_7881(stack, entity) - timeCharged, stack, entity)) >= 0.085) {
            List projectiles = SlingshotItem.method_57390((class_1799)stack, (class_1799)ammo, (class_1309)player);
            boolean noGravity = class_1890.method_60142((class_1799)stack, ModEnchantments.PROJECTILE_NO_GRAVITY.get());
            power *= (float)((CommonConfigs.Tools.SLINGSHOT_RANGE.get() + (noGravity ? 0.5 : 0.0)) * 1.1);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (!projectiles.isEmpty()) {
                    this.method_57393(serverLevel, (class_1309)player, player.method_6058(), stack, projectiles, power, 1.0f, false, null);
                }
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
    }

    protected class_1676 method_57344(class_1937 level, class_1309 shooter, class_1799 weapon, class_1799 ammo, boolean isCrit) {
        return new SlingshotProjectileEntity(level, ammo, weapon, shooter);
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float velocity, float inaccuracy, float angle, @Nullable class_1309 target) {
        Vector3f vector3f;
        if (target != null) {
            double d = target.method_23317() - shooter.method_23317();
            double e = target.method_23321() - shooter.method_23321();
            double f = Math.sqrt(d * d + e * e);
            double g = target.method_23323(0.3333333333333333) - projectile.method_23318() + f * (double)0.2f;
            vector3f = SlingshotItem.getProjectileShotVector(shooter, new class_243(d, g, e), angle);
        } else {
            class_243 vec3 = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_243 vec32 = shooter.method_5828(1.0f);
            vector3f = vec32.method_46409().rotate((Quaternionfc)quaternionf);
        }
        projectile.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float pitch = SlingshotItem.getShotPitch(shooter.method_59922(), index);
        shooter.method_37908().method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), ModSounds.SLINGSHOT_SHOOT.get(), shooter.method_5634(), 1.0f, pitch);
    }

    private static Vector3f getProjectileShotVector(class_1309 shooter, class_243 distance, float angle) {
        Vector3f vector3f = distance.method_46409().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            class_243 vec3 = shooter.method_18864(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.method_46409());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    private static float getShotPitch(class_5819 random, int index) {
        return index == 0 ? 1.0f : SlingshotItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, class_5819 random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    public int method_7881(class_1799 itemStack, class_1309 livingEntity) {
        return 72000;
    }

    public static float getPowerForTime(float charge, class_1799 stack, class_1309 entity) {
        float f = charge / (float)SlingshotItem.getChargeDuration(stack, entity);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeDuration(class_1799 stack, class_1309 shooter) {
        float f = class_1890.method_60159((class_1799)stack, (class_1309)shooter, (float)CommonConfigs.Tools.SLINGSHOT_CHARGE.get().intValue()) / 20.0f;
        return class_3532.method_15375((float)(f * 20.0f));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        VibeChecker.assertSameLevel(level, player);
        class_1799 itemstack = player.method_5998(hand);
        boolean flag = this.method_19268().test(player.method_18808(itemstack));
        if (!flag) {
            return class_1271.method_22431((Object)itemstack);
        }
        player.method_6019(hand);
        player.method_37908().method_43129(player, (class_1297)player, this.getChargeSound(itemstack), class_3419.field_15248, 1.0f, 1.0f * (1.0f / (level.field_9229.method_43057() * 0.3f + 0.9f)));
        return class_1271.method_22428((Object)itemstack);
    }

    public class_3414 getChargeSound(class_1799 stack) {
        Pair pair = class_1890.method_60174((class_1799)stack, (class_9331)class_9701.field_51677);
        int i = pair == null ? 0 : (Integer)pair.getSecond();
        return switch (i) {
            case 0 -> ModSounds.SLINGSHOT_CHARGE_0.get();
            case 1 -> ModSounds.SLINGSHOT_CHARGE_1.get();
            case 2 -> ModSounds.SLINGSHOT_CHARGE_2.get();
            default -> ModSounds.SLINGSHOT_CHARGE_3.get();
        };
    }

    public Predicate<class_1799> method_19268() {
        return s -> {
            class_1792 i = s.method_7909();
            if (i instanceof class_4537) {
                return CommonConfigs.Tools.SLINGSHOT_POTIONS.get();
            }
            if (i instanceof BombItem) {
                return CommonConfigs.Tools.SLINGSHOT_BOMBS.get();
            }
            if (i instanceof class_1823) {
                return CommonConfigs.Tools.SLINGSHOT_SNOWBALL.get();
            }
            if (i instanceof class_1776) {
                return CommonConfigs.Tools.SLINGSHOT_ENDERPEARLS.get();
            }
            if (i instanceof class_1778) {
                return CommonConfigs.Tools.SLINGSHOT_FIRECHARGE.get();
            }
            if (i instanceof class_5633 && i.method_7857()) {
                return CommonConfigs.Tools.SLINGSHOT_BUCKETS.get();
            }
            if (s.method_31573(ModTags.SLINGSHOT_DAMAGEABLE)) {
                return true;
            }
            return !(i instanceof class_5633) && !s.method_31573(ModTags.SLINGSHOT_BLACKLIST) && i instanceof class_1747 || AdditionalItemPlacementsAPI.hasBehavior((class_1792)i) || InteractEventsHandler.hasBlockPlacementAssociated(i);
        };
    }

    public int method_24792() {
        return 10;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public <T extends class_1309> boolean poseLeftArm(class_1799 stack, class_572<T> model, T entity, class_1306 mainHand) {
        if (entity.method_6014() > 0 && entity.method_6030().method_7909() == this) {
            model.field_27433.field_3675 = MthUtils.wrapRad((float)(0.1f + model.field_3398.field_3675));
            model.field_27433.field_3654 = MthUtils.wrapRad((float)(-1.5707964f + model.field_3398.field_3654));
            return true;
        }
        return false;
    }

    public boolean isTwoHanded() {
        return false;
    }

    public <T extends class_1309> boolean poseRightArm(class_1799 stack, class_572<T> model, T entity, class_1306 mainHand) {
        if (entity.method_6014() > 0 && entity.method_6030().method_7909() == this) {
            model.field_3401.field_3675 = MthUtils.wrapRad((float)(-0.1f + model.field_3398.field_3675));
            model.field_3401.field_3654 = MthUtils.wrapRad((float)(-1.5707964f + model.field_3398.field_3654));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(class_1657 entity, class_1799 stack, class_1268 hand, class_1306 humanoidArm, class_4587 matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.method_6115() && entity.method_6014() > 0 && entity.method_6058() == hand) {
            float useDuration = (float)stack.method_7935((class_1309)entity) - ((float)entity.method_6014() - partialTicks + 1.0f);
            float power = SlingshotItem.getPowerForTime(useDuration, stack, (class_1309)entity);
            if (power > 0.1f) {
                float f15 = class_3532.method_15374((float)((useDuration - 0.1f) * 1.3f));
                float f18 = power - 0.1f;
                float f20 = f15 * f18;
                matrixStack.method_46416(0.0f, f20 * 0.004f, 0.0f);
            }
            matrixStack.method_46416(0.0f, 0.0f, power * 0.04f);
            matrixStack.method_22905(1.0f, 1.0f, 1.0f + power * 0.2f);
        }
    }
}

