/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.items.components.MobContainerView;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4094;
import net.minecraft.class_4140;
import net.minecraft.class_4151;
import net.minecraft.class_4836;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5354;
import net.minecraft.class_5819;

public abstract class AbstractMobContainerItem
extends class_1747 {
    private final float mobContainerHeight;
    private final float mobContainerWidth;
    private final boolean isAquarium;

    protected AbstractMobContainerItem(class_2248 block, class_1792.class_1793 properties, float width, float height, boolean aquarium) {
        super(block, properties);
        this.mobContainerWidth = width;
        this.mobContainerHeight = height;
        this.isAquarium = aquarium;
    }

    public boolean method_31568() {
        return false;
    }

    public boolean isAquarium() {
        return this.isAquarium;
    }

    public float getMobContainerHeight() {
        return this.mobContainerHeight;
    }

    public float getMobContainerWidth() {
        return this.mobContainerWidth;
    }

    protected boolean canFitEntity(class_1297 e) {
        float margin = 0.125f;
        float h = e.method_17682() - margin;
        float w = e.method_17681() - margin;
        return w < this.mobContainerWidth && h < this.mobContainerHeight;
    }

    public void playCatchSound(class_1657 player) {
    }

    public void playFailSound(class_1657 player) {
    }

    public void playReleaseSound(class_1937 world, class_243 v) {
    }

    public int getMaxStackSize(class_1799 stack) {
        return this.isFull(stack) ? 1 : 64;
    }

    public boolean isFull(class_1799 stack) {
        return stack.method_57826(ModComponents.MOB_HOLDER_CONTENT.get());
    }

    public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        if (this.isFull(stack)) {
            return false;
        }
        class_1268 hand = player.method_6058();
        if (hand == class_1268.field_5810) {
            return false;
        }
        return this.doInteract(stack, player, entity, player.method_6058()).method_23665();
    }

    private <T extends class_1297> boolean canCatch(T entity, class_1657 player) {
        class_1309 living;
        if (!entity.method_5805() || entity instanceof class_1657) {
            return false;
        }
        String name = Utils.getID((class_1299)entity.method_5864()).toString();
        if (CommonConfigs.Functional.CAGE_ALL_MOBS.get().booleanValue() || CapturedMobHandler.getInstance(entity.method_37908()).isCommandMob(name)) {
            return true;
        }
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_29504()) {
            return false;
        }
        if (entity.method_5864().method_20210(ModTags.CAPTURE_BLACKLIST)) {
            return false;
        }
        if (ForgeHelper.isMultipartEntity(entity)) {
            return false;
        }
        ICatchableMob cap = CapturedMobHandler.getInstance(entity.method_37908()).getCatchableMobCapOrDefault(entity);
        return cap.canBeCaughtWithItem(entity, (class_1792)this, player);
    }

    public abstract boolean canItemCatch(class_1297 var1);

    public class_1799 saveEntityInItem(class_1297 entity, class_1799 currentStack, class_1799 bucketStack) {
        class_1799 returnStack = currentStack.method_46651(1);
        MobContainer mobContainer = new MobContainer(this.getMobContainerWidth(), this.getMobContainerHeight(), this.isAquarium);
        boolean success = mobContainer.captureEntity(entity, bucketStack);
        if (success) {
            returnStack.method_57379(ModComponents.MOB_HOLDER_CONTENT.get(), (Object)MobContainerView.of(mobContainer));
            return returnStack;
        }
        return currentStack;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        MobContainerView content = (MobContainerView)stack.method_57824(ModComponents.MOB_HOLDER_CONTENT.get());
        class_1657 player = context.method_8036();
        if (!context.method_8036().method_5715() && content != null) {
            MobContainer.MobData data = content.getDataUnsafe();
            boolean success = false;
            class_1937 world = context.method_8045();
            class_243 v = context.method_17698();
            if (data instanceof MobContainer.MobData.Bucket) {
                MobContainer.MobData.Bucket b = (MobContainer.MobData.Bucket)data;
                class_1799 bucketStack = b.getBucket();
                class_1792 class_17922 = bucketStack.method_7909();
                if (class_17922 instanceof class_1755) {
                    class_1755 bi = (class_1755)class_17922;
                    bi.method_7728(player, world, bucketStack.method_7972(), context.method_8037());
                    success = true;
                }
            } else if (data instanceof MobContainer.MobData.Entity) {
                MobContainer.MobData.Entity e = (MobContainer.MobData.Entity)data;
                class_1297 entity = class_1299.method_17842((class_2487)e.getTag(), (class_1937)world, o -> o);
                if (entity != null) {
                    success = true;
                    if (!world.field_9236) {
                        if (!player.method_7337() && entity instanceof class_5354) {
                            class_5354 ang = (class_5354)entity;
                            if (!entity.method_5864().method_20210(ModTags.NON_ANGERABLE)) {
                                ang.method_29921();
                                ang.method_29513(player.method_5667());
                                ang.method_6015((class_1309)player);
                            }
                        }
                        entity.method_5641(v.method_10216(), v.method_10214(), v.method_10215(), context.method_8044(), 0.0f);
                        if (CommonConfigs.Functional.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof class_1308) {
                            class_1308 mob = (class_1308)entity;
                            mob.method_5971();
                        }
                        UUID temp = entity.method_5667();
                        UUID dataUUID = e.getUuid();
                        if (dataUUID != null) {
                            entity.method_5826(dataUUID);
                        }
                        if (!world.method_8649(entity)) {
                            entity.method_5826(temp);
                            success = world.method_8649(entity);
                            if (!success) {
                                Supplementaries.LOGGER.warn("Failed to release caged mob");
                            }
                        }
                    }
                    if (player.method_7337() && e.getUuid() != null) {
                        stack.method_57379(ModComponents.MOB_HOLDER_CONTENT.get(), (Object)content.copyWithNewUUID(class_3532.method_15378((class_5819)world.field_9229)));
                    }
                } else {
                    Supplementaries.LOGGER.error("Failed to load entity from itemstack");
                }
            }
            if (success) {
                if (!world.field_9236) {
                    this.playReleaseSound(world, v);
                    if (!player.method_56992()) {
                        class_1799 returnItem = stack.method_46651(1);
                        returnItem.method_57381(ModComponents.MOB_HOLDER_CONTENT.get());
                        Utils.swapItemNBT((class_1657)player, (class_1268)context.method_20287(), (class_1799)stack, (class_1799)returnItem);
                    }
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        return super.method_7884(context);
    }

    public boolean blocksPlacement() {
        return true;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        MobContainerView content = (MobContainerView)stack.method_57824(ModComponents.MOB_HOLDER_CONTENT.get());
        if (content != null) {
            content.method_57409(context, tooltipComponents::add, tooltipFlag);
        }
        if (MiscUtils.showsHints(tooltipFlag)) {
            this.addPlacementTooltip(tooltipComponents);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void addPlacementTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43469((String)"message.supplementaries.cage.tooltip", (Object[])new Object[]{class_310.method_1551().field_1690.field_1832.method_16007()}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
    }

    private void angerNearbyEntities(class_1297 entity, class_1657 player) {
        if (entity instanceof class_5354 && entity instanceof class_1308) {
            AbstractMobContainerItem.getEntitiesInRange((class_1308)entity).stream().filter(mob -> mob != entity).map(class_5354.class::cast).forEach(mob -> {
                mob.method_29921();
                mob.method_29513(player.method_5667());
                mob.method_6015((class_1309)player);
            });
        }
        class_1937 level = entity.method_37908();
        if (entity instanceof class_4836) {
            entity.method_5643(level.method_48963().method_48802(player), 0.0f);
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                Optional optional = villager.method_18868().method_18904(class_4140.field_18442);
                optional.ifPresent(entities -> entities.method_38978(class_4094.class::isInstance).forEach(e -> serverLevel.method_19496(class_4151.field_18476, (class_1297)player, (class_4094)e)));
            }
        }
    }

    private static List<?> getEntitiesInRange(class_1308 e) {
        double d0 = e.method_45325(class_5134.field_23717);
        class_238 aabb = class_238.method_29968((class_243)e.method_19538()).method_1009(d0, 10.0, d0);
        return e.method_37908().method_8390(e.getClass(), aabb, class_1301.field_6155);
    }

    public class_1269 doInteract(class_1799 stack, class_1657 player, class_1297 entity, class_1268 hand) {
        if (hand == null) {
            return class_1269.field_5811;
        }
        boolean canCatch = this.canCatch(entity, player);
        class_5250 failedMessage = class_2561.method_43471((String)"message.supplementaries.cage.fail");
        if (canCatch && entity instanceof class_1309) {
            int percentage;
            class_1321 pet;
            class_1309 le = (class_1309)entity;
            if (CommonConfigs.Functional.CAGE_TAMED.get().booleanValue() && entity instanceof class_1321 && (!(pet = (class_1321)entity).method_6181() || !pet.method_6171((class_1309)player))) {
                failedMessage = class_2561.method_43471((String)"message.supplementaries.cage.fail_tamed");
                canCatch = false;
            }
            if ((percentage = CommonConfigs.Functional.CAGE_HEALTH_THRESHOLD.get().intValue()) != 100 && le.method_6032() > le.method_6063() * ((float)percentage / 100.0f)) {
                failedMessage = class_2561.method_43469((String)"message.supplementaries.cage.fail_health", (Object[])new Object[]{percentage});
                canCatch = false;
            }
        }
        if (canCatch) {
            class_1799 newItem;
            class_1799 bucket = class_1799.field_8037;
            if (this.isAquarium) {
                bucket = BucketHelper.getBucketFromEntity(entity);
            }
            if (CommonConfigs.Functional.CAGE_PERSISTENT_MOBS.get().booleanValue() && entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5971();
            }
            if ((newItem = this.saveEntityInItem(entity, stack, bucket)) == stack) {
                return class_1269.field_5814;
            }
            this.playCatchSound(player);
            if (player.method_37908().field_9236) {
                return class_1269.field_5812;
            }
            Utils.swapItemNBT((class_1657)player, (class_1268)hand, (class_1799)stack, (class_1799)newItem);
            this.angerNearbyEntities(entity, player);
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5932(true, !player.method_31549().field_7477);
            }
            entity.method_5650(class_1297.class_5529.field_26999);
            return class_1269.field_21466;
        }
        if (!player.method_37908().field_9236 && entity instanceof class_1309) {
            player.method_7353((class_2561)failedMessage, true);
        }
        this.playFailSound(player);
        return class_1269.field_5811;
    }

    public class_1269 method_7712(class_1750 context) {
        class_1657 player = context.method_8036();
        if (player != null && !player.method_5715() && this.blocksPlacement()) {
            return class_1269.field_5811;
        }
        return super.method_7712(context);
    }
}

