/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1680;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1776;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1823;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4537;
import net.minecraft.class_5633;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class SlingshotProjectileEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(SlingshotProjectileEntity.class, (class_2941)class_2943.field_13319);
    protected int MAX_AGE = 700;
    private float xRotInc;
    private float yRotInc;
    private float particleCooldown = 0.0f;
    private final Supplier<Integer> light = Suppliers.memoize(() -> {
        class_1792 item = this.method_7495().method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 b = blockItem.method_7711();
            return b.method_9564().method_26213();
        }
        return 0;
    });

    public SlingshotProjectileEntity(class_1937 world, class_1799 item, class_1799 throwerStack, @Nullable class_1309 thrower) {
        this(world, item, throwerStack);
        if (thrower != null) {
            this.method_5814(thrower.method_23317(), thrower.method_23320() - 0.1, thrower.method_23321());
            this.method_7432((class_1297)thrower);
        }
    }

    public SlingshotProjectileEntity(class_1937 world, class_1799 item, class_1799 throwerStack) {
        super(ModEntities.SLINGSHOT_PROJECTILE.get(), world);
        this.maxAge = this.MAX_AGE;
        this.method_16940(item);
        this.setLoyalty(this.getLoyaltyFromItem(item));
        this.method_5875(class_1890.method_60142((class_1799)throwerStack, ModEnchantments.PROJECTILE_NO_GRAVITY.get()));
        this.yRotInc = (float)(this.field_5974.method_43056() ? 1 : -1) * (float)(4.0 * this.field_5974.method_43059() + 7.0);
        this.xRotInc = (float)(this.field_5974.method_43056() ? 1 : -1) * (float)(4.0 * this.field_5974.method_43059() + 7.0);
        this.method_36457(this.field_5974.method_43057() * 360.0f);
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.maxStuckTime = 0;
    }

    public SlingshotProjectileEntity(class_1299<SlingshotProjectileEntity> type, class_1937 world) {
        super(type, world);
        this.maxAge = this.MAX_AGE;
        this.maxStuckTime = 0;
    }

    private byte getLoyaltyFromItem(class_1799 itemStack) {
        byte by;
        class_1937 var3 = this.method_37908();
        if (var3 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)var3;
            by = (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverLevel, (class_1799)itemStack, (class_1297)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return PlatHelper.getEntitySpawnPacket((class_1297)this, (class_3231)serverEntity);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setLoyalty(tag.method_10571("Loyalty"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567("Loyalty", this.getLoyalty());
    }

    private void setLoyalty(byte loyalty) {
        this.field_6011.method_12778(LOYALTY, (Object)loyalty);
    }

    public byte getLoyalty() {
        return (Byte)this.field_6011.method_12789(LOYALTY);
    }

    protected class_1792 method_16942() {
        return class_1802.field_20391;
    }

    protected void method_7454(class_3966 entityRayTraceResult) {
        class_1297 class_12972;
        super.method_7454(entityRayTraceResult);
        class_1799 stack = this.method_7495();
        if (!this.tryDeployingProjectiles() && (class_12972 = entityRayTraceResult.method_17782()) instanceof class_1560) {
            class_1747 bi;
            class_2248 block;
            class_1560 enderman = (class_1560)class_12972;
            class_1792 item = stack.method_7909();
            if (item instanceof class_1747 && ((block = (bi = (class_1747)item).method_7711()).method_40142().method_40220(class_3481.field_15460) || CommonConfigs.Tools.UNRESTRICTED_SLINGSHOT.get().booleanValue()) && enderman.method_7027() == null) {
                enderman.method_7032(block.method_9564());
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
        if (stack.method_31573(ModTags.SLINGSHOT_DAMAGEABLE)) {
            float speed = (float)this.method_18798().method_1033();
            double baseDamage = CommonConfigs.Tools.SLINGSHOT_DAMAGEABLE_DAMAGE.get();
            int damage = class_3532.method_15384((double)class_3532.method_15350((double)((double)speed * baseDamage), (double)0.0, (double)2.147483647E9));
            entityRayTraceResult.method_17782().method_5643(ModDamageSources.slingshot(this.method_37908(), (class_1297)this, this.method_24921()), (float)damage);
            this.method_5768();
        }
    }

    protected void method_24920(class_3965 hit) {
        class_1657 p;
        super.method_24920(hit);
        class_1937 level = this.method_37908();
        class_1799 stack = this.method_7495();
        class_1792 item = stack.method_7909();
        class_1297 class_12972 = this.method_24921();
        class_1657 player = class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : FakePlayerManager.getDefault((class_1297)this, (class_1297)this);
        boolean success = this.tryDeployingProjectiles();
        if (!success && item instanceof class_5633) {
            class_5633 dc = (class_5633)item;
            if (item.method_7857()) {
                class_1792 craftingRemainingItem = stack.method_7909().method_7858();
                SuppPlatformStuff.dispenseContent(dc, stack, hit, level, player);
                dc.method_7728(player, level, stack, hit.method_17777());
                if (craftingRemainingItem != null) {
                    this.method_16940(craftingRemainingItem.method_7854());
                } else {
                    success = true;
                }
            }
        }
        if (!success) {
            class_1750 context = new class_1750(level, player, class_1268.field_5808, stack, hit);
            success = ItemsUtil.place(item, context).method_23665();
            this.isStuck = true;
        }
        if (success) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private boolean tryDeployingProjectiles() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 le = (class_1309)class_12972;
            Object ent = null;
            class_1792 item = this.method_7495().method_7909();
            class_1937 level = this.method_37908();
            if (item instanceof class_4537) {
                class_1686 p = new class_1686(level, le);
                p.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                p.method_16940(this.method_7495());
                ent = p;
            } else if (item == class_1802.field_8814) {
                class_1677 p = new class_1677(level, le, class_243.field_1353);
                p.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                p.method_16936(this.method_7495());
                ent = p;
            } else if (item instanceof class_1823) {
                class_1680 s = new class_1680(level, le);
                s.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                s.method_16940(this.method_7495());
                ent = s;
            } else if (item instanceof BombItem) {
                BombItem bi = (BombItem)item;
                BombEntity s = new BombEntity(level, le, bi.getType());
                s.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                s.method_16940(this.method_7495());
                ent = s;
            } else if (item instanceof class_1776) {
                class_1684 s = new class_1684(level, le);
                s.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                s.method_16940(this.method_7495());
                ent = s;
            }
            if (ent != null) {
                level.method_8649(ent);
                ent.method_5773();
                return true;
            }
        }
        return false;
    }

    public void method_5773() {
        if (this.isNoPhysics()) {
            byte loyaltyLevel = this.getLoyalty();
            class_1297 owner = this.method_24921();
            if (loyaltyLevel > 0 && this.isAcceptableReturnOwner(owner)) {
                class_243 force = new class_243(owner.method_23317() - this.method_23317(), owner.method_23320() - this.method_23318(), owner.method_23321() - this.method_23321());
                this.method_23327(this.method_23317(), this.method_23318() + force.field_1351 * 0.015 * (double)loyaltyLevel, this.method_23321());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(force.method_1029().method_1021(d0)));
            }
        }
        super.method_5773();
    }

    private boolean isAcceptableReturnOwner(class_1297 owner) {
        if (owner != null && owner.method_5805()) {
            return !(owner instanceof class_3222) || !owner.method_7325();
        }
        return false;
    }

    public void method_5694(class_1657 playerEntity) {
        if (!this.method_37908().field_9236 && this.hasLeftOwner() && (this.isNoPhysics() || this.isStuck)) {
            boolean success = playerEntity.method_31549().field_7477 || playerEntity.method_31548().method_7394(this.method_7495());
            class_1937 level = this.method_37908();
            if (!success) {
                this.method_5699(this.method_7495(), 0.1f);
            } else {
                level.method_43129(null, (class_1297)playerEntity, class_3417.field_15197, class_3419.field_15248, 0.2f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 1.4f + 2.0f);
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public boolean hasReachedEndOfLife() {
        if (this.method_5740() && this.method_18798().method_1027() < 0.005) {
            return true;
        }
        return super.hasReachedEndOfLife();
    }

    public void reachedEndOfLife() {
        if (this.getLoyalty() != 0 && this.isAcceptableReturnOwner(this.method_24921())) {
            this.setNoPhysics(true);
            this.stuckTime = 0;
        } else {
            this.method_5699(this.method_7495(), 0.1f);
            super.reachedEndOfLife();
        }
    }

    protected void method_26962() {
        if (!this.method_5740()) {
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_36457(this.method_36455() + this.xRotInc);
            this.method_36456(this.method_36454() + this.yRotInc);
            this.particleCooldown += 1.0f;
        } else {
            super.method_26962();
        }
    }

    public void spawnTrailParticles() {
        super.spawnTrailParticles();
        if (!this.isNoPhysics()) {
            double speed = this.method_18798().method_1033();
            if (this.field_6012 > 1 && speed * (double)this.field_6012 > 1.5) {
                if (this.method_5740()) {
                    class_243 rot = new class_243(0.325, 0.0, 0.0).method_1024((float)this.field_6012 * 0.32f);
                    class_243 movement = this.method_18798();
                    class_243 offset = MthUtils.changeBasisN((class_243)movement, (class_243)rot);
                    double px = this.method_23317() + offset.field_1352;
                    double py = this.method_23320() + offset.field_1351;
                    double pz = this.method_23321() + offset.field_1350;
                    movement = movement.method_1021(0.25);
                    this.method_37908().method_8406((class_2394)ModParticles.STASIS_PARTICLE.get(), px, py, pz, movement.field_1352, movement.field_1351, movement.field_1350);
                } else {
                    double interval = 3.0 / (speed * 0.95 + 0.05);
                    if ((double)this.particleCooldown > interval) {
                        this.particleCooldown = (float)((double)this.particleCooldown - interval);
                        double x = this.method_23317();
                        double y = this.method_23320();
                        double z = this.method_23321();
                        this.method_37908().method_8406((class_2394)ModParticles.SLINGSHOT_PARTICLE.get(), x, y, z, 0.0, 0.01, 0.0);
                    }
                }
            }
        }
    }

    protected float getInertia() {
        return this.method_5740() ? (float)CommonConfigs.Tools.SLINGSHOT_DECELERATION.get().doubleValue() : super.getInertia();
    }

    public void writeSpawnData(class_9129 buffer) {
        class_1297 entity = this.method_24921();
        int id = -1;
        if (entity != null) {
            id = entity.method_5628();
        }
        buffer.method_53002(id);
        buffer.method_52941(this.xRotInc);
        buffer.method_52941(this.yRotInc);
        buffer.method_52941(this.method_36455());
        buffer.method_52941(this.method_36454());
    }

    public void readSpawnData(class_9129 buffer) {
        int id = buffer.readInt();
        if (id != -1) {
            this.method_7432(this.method_37908().method_8469(id));
        }
        this.xRotInc = buffer.readFloat();
        this.yRotInc = buffer.readFloat();
        this.method_36457(buffer.readFloat());
        this.method_36456(buffer.readFloat());
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
    }

    public int getLightEmission() {
        return this.light.get();
    }
}

