/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.SignPostScreen;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_7225;
import net.minecraft.class_9062;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolderProvider,
IScreenProvider {
    public static final ModelDataKey<Boolean> FRAMED_KEY = ModBlockProperties.FRAMED;
    public static final ModelDataKey<Float> RENDER_OFFSET_KEY = ModBlockProperties.RENDER_OFFSET;
    public static final ModelDataKey<Sign> SIGN_UP_KEY = ModBlockProperties.SIGN_UP;
    public static final ModelDataKey<Sign> SIGN_DOWN_KEY = ModBlockProperties.SIGN_DOWN;
    private final Sign signUp = new Sign(false, true, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private final Sign signDown = new Sign(false, false, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private boolean isWaxed = false;
    private float zRenderOffset = 0.0f;
    private boolean framed = false;
    @Nullable
    private UUID playerWhoMayEdit;

    public SignPostBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.WAY_SIGN_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(FRAMED_KEY, (Object)this.framed).with(SIGN_UP_KEY, (Object)this.signUp).with(SIGN_DOWN_KEY, (Object)this.signDown).with(RENDER_OFFSET_KEY, (Object)Float.valueOf(this.zRenderOffset));
    }

    @Override
    public TextHolder getTextHolder(int i) {
        return this.getSign((boolean)(i == 0 ? true : false)).text;
    }

    @Override
    public TextHolder getTextHolderAt(class_243 hit) {
        return this.getClickedSign((class_243)hit).text;
    }

    @Override
    public int textHoldersCount() {
        return 2;
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.method_11016();
        return new class_238((double)pos.method_10263() - 0.25, (double)pos.method_10264(), (double)pos.method_10260() - 0.25, (double)pos.method_10263() + 1.25, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 1.25);
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return this.signUp.getPointing();
        }
        return this.signDown.getPointing();
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        class_2470 rot;
        class_2680 state;
        super.method_11014(tag, registries);
        this.framed = tag.method_10577("Framed");
        this.signUp.load(tag.method_10562("SignUp"), registries, this.field_11867);
        this.signDown.load(tag.method_10562("SignDown"), registries, this.field_11867);
        if (tag.method_10545("Waxed")) {
            this.isWaxed = tag.method_10577("Waxed");
        }
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.requestModelReload();
        }
        if ((state = this.method_11010()).method_28498(ModBlockProperties.ROTATE_TILE) && this.field_11863 != null && (rot = (class_2470)state.method_11654(ModBlockProperties.ROTATE_TILE)) != class_2470.field_11467) {
            this.rotateSign(false, rot.ordinal() * 90, false);
            this.rotateSign(true, rot.ordinal() * 90, false);
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657(ModBlockProperties.ROTATE_TILE, (Comparable)class_2470.field_11467));
        }
    }

    public boolean setHeldBlock(class_2680 state, int index) {
        class_2248 b = state.method_26204();
        this.zRenderOffset = b instanceof StickBlock ? 0.5625f : (b == class_2246.field_10124 ? 0.0f : 0.625f);
        return super.setHeldBlock(state, index);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (this.mimic.method_26215()) {
            tag.method_10551("Mimic");
        }
        tag.method_10556("Framed", this.framed);
        tag.method_10566("SignUp", (class_2520)this.signUp.save(registries));
        tag.method_10566("SignDown", (class_2520)this.signDown.save(registries));
        if (this.isWaxed) {
            tag.method_10556("Waxed", this.isWaxed);
        }
    }

    public boolean rotateSign(boolean up, float angle, boolean constrainAngle) {
        if (up && this.signUp.active) {
            this.signUp.rotateBy(angle, constrainAngle);
            return true;
        }
        if (this.signDown.active) {
            this.signDown.rotateBy(angle, constrainAngle);
            return true;
        }
        return false;
    }

    public void openScreen(class_1937 level, class_1657 player, class_2350 direction) {
        SignPostScreen.open(this);
    }

    public float getOffset() {
        return this.zRenderOffset;
    }

    public Sign getSignUp() {
        return this.signUp;
    }

    public Sign getSignDown() {
        return this.signDown;
    }

    public Sign getSign(boolean up) {
        return up ? this.getSignUp() : this.getSignDown();
    }

    public boolean isFramed() {
        return this.framed;
    }

    public boolean trySetSign(WoodType woodType, int r, boolean up, boolean framed) {
        Sign sign = this.getSign(up);
        if (!sign.active) {
            sign.active = true;
            sign.woodType = woodType;
            sign.yaw = this.method_11010().method_28498((class_2769)class_2383.field_11177) ? 90.0f - ((class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177)).method_10144() : 90.0f + (float)r * -22.5f;
            this.framed = framed;
            return true;
        }
        return false;
    }

    public class_9062 handleInteraction(class_2680 state, class_3218 level, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit, class_1799 itemstack) {
        class_1792 item = itemstack.method_7909();
        boolean emptyHand = itemstack.method_7960();
        boolean isSneaking = player.method_5715() && emptyHand;
        boolean ind = this.getClickedSignIndex(hit.method_17784());
        if (hit.method_17780().method_10166() != class_2350.class_2351.field_11052) {
            boolean success;
            Sign sign = this.getSign(ind);
            if (!sign.active && item instanceof SignPostItem) {
                return class_9062.field_47731;
            }
            if (isSneaking) {
                sign.toggleDirection();
                this.method_5431();
                level.method_8413(pos, state, state, 3);
                level.method_8396(null, pos, ModSounds.BLOCK_ROTATE.get(), class_3419.field_15245, 1.0f, 1.0f);
                return class_9062.field_47729;
            }
            if (item instanceof class_1759 && !state.method_28498((class_2769)class_2383.field_11177)) {
                class_2338 pointingPos = SignPostBlockTile.getCompassTrackedPos(level, itemstack);
                if (pointingPos != null) {
                    if (sign.active) {
                        sign.pointToward(pos, pointingPos);
                    }
                    this.method_5431();
                    level.method_8413(pos, state, state, 3);
                    return class_9062.field_47729;
                }
                return class_9062.field_47733;
            }
            if (CompatHandler.FRAMEDBLOCKS && this.framed && (success = FramedBlocksCompat.interactWithFramedSignPost(this, player, handIn, itemstack, (class_1937)level, pos))) {
                return class_9062.field_47729;
            }
        }
        return this.textHolderInteract(ind ? 0 : 1, (class_1937)level, pos, state, player, handIn, itemstack, hit.method_17780());
    }

    private static class_2338 getCompassTrackedPos(class_3218 level, class_1799 itemstack) {
        class_9291 tracker = (class_9291)itemstack.method_57824(class_9334.field_49614);
        if (tracker != null && tracker.comp_2402().isPresent()) {
            class_4208 gp = (class_4208)tracker.comp_2402().get();
            if (level.method_27983() == gp.comp_2207()) {
                return ((class_4208)tracker.comp_2402().get()).comp_2208();
            }
        }
        return level.method_8597().comp_645() ? level.method_8401().method_56126() : null;
    }

    public boolean getClickedSignIndex(class_243 hit) {
        double y = hit.field_1351;
        y = y < 0.0 ? (y += (double)(1 - (int)y)) : (y -= (double)((int)y));
        return y > 0.5;
    }

    public Sign getClickedSign(class_243 hit) {
        return this.getSign(this.getClickedSignIndex(hit));
    }

    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public static final class Sign {
        public final TextHolder text;
        private boolean active;
        private boolean left;
        private float yaw;
        private WoodType woodType;

        private Sign(boolean active, boolean left, float yaw, WoodType woodType) {
            this.active = active;
            this.left = left;
            this.yaw = yaw;
            this.woodType = woodType;
            this.text = new TextHolder(1, 90);
        }

        public void load(class_2487 compound, class_7225.class_7874 registries, class_2338 pos) {
            this.active = compound.method_10577("Active");
            this.left = compound.method_10577("Left");
            this.yaw = compound.method_10583("Yaw");
            this.woodType = (WoodType)WoodTypeRegistry.INSTANCE.get(class_2960.method_60654((String)compound.method_10558("WoodType")));
            this.text.load(compound, registries, pos);
        }

        public class_2487 save(class_7225.class_7874 registries) {
            class_2487 compound = new class_2487();
            compound.method_10548("Yaw", this.yaw);
            compound.method_10556("Left", this.left);
            compound.method_10556("Active", this.active);
            compound.method_10582("WoodType", this.woodType.toString());
            this.text.save(compound, registries);
            return compound;
        }

        public void pointToward(class_2338 myPos, class_2338 targetPos) {
            float yaw = (float)(Math.atan2((double)targetPos.method_10263() - (double)myPos.method_10263(), (double)targetPos.method_10260() - (double)myPos.method_10260()) * 57.2957763671875);
            this.setYaw(yaw);
        }

        private float getPointing() {
            return class_3532.method_15393((float)(-this.yaw - (float)(this.left ? 180 : 0)));
        }

        private void setYaw(float yaw) {
            this.yaw = class_3532.method_15393((float)(yaw - (float)(this.left ? 180 : 0)));
        }

        private void rotateBy(float angle, boolean constrainAngle) {
            this.yaw = class_3532.method_15393((float)(this.yaw + angle));
            if (constrainAngle) {
                this.yaw -= this.yaw % 22.5f;
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }

        public void setWoodType(WoodType woodType) {
            this.woodType = woodType;
        }

        public boolean active() {
            return this.active;
        }

        public boolean left() {
            return this.left;
        }

        public float yaw() {
            return this.yaw;
        }

        public WoodType woodType() {
            return this.woodType;
        }

        public void toggleDirection() {
            this.left = !this.left;
        }

        public class_1799 getItem() {
            return new class_1799((class_1935)ModRegistry.WAY_SIGN_ITEMS.get(this.woodType));
        }
    }
}

