/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.data.Material;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class WorkbenchContructingRecipe
implements class_1860<class_9696> {
    private final class_2371<StackedIngredient> materials;
    private final class_1799 result;
    private final boolean notification;

    public WorkbenchContructingRecipe(class_2371<StackedIngredient> materials, class_1799 result, boolean notification) {
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get();
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRecipeSerializers.WORKBENCH_RECIPE.get();
    }

    public boolean matches(class_9696 input, class_1937 level) {
        return true;
    }

    public class_1799 assemble(class_9696 input, class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.result;
    }

    public boolean method_49188() {
        return this.notification;
    }

    public class_2371<StackedIngredient> getMaterials() {
        return this.materials;
    }

    public int getResultId() {
        return class_1792.method_7880((class_1792)this.result.method_7909());
    }

    public class_1799 getResult() {
        return this.result;
    }

    public static Builder builder(class_1935 result, int count, Function<class_1935, class_175<?>> hasItem, Function<class_6862<class_1792>, class_175<?>> hasTag) {
        return new Builder(result.method_8389(), count, hasItem, hasTag);
    }

    public static class Builder
    implements class_5797 {
        private final class_1792 result;
        private final int count;
        private final Function<class_1935, class_175<?>> hasItem;
        private final Function<class_6862<class_1792>, class_175<?>> hasTag;
        private final class_2371<StackedIngredient> materials = class_2371.method_10211();
        private final Map<String, class_175<?>> criteria = new LinkedHashMap();
        private class_7800 category = class_7800.field_40642;
        private boolean showNotification;

        private Builder(class_1792 result, int count, Function<class_1935, class_175<?>> hasItem, Function<class_6862<class_1792>, class_175<?>> hasTag) {
            this.result = result;
            this.count = count;
            this.hasItem = hasItem;
            this.hasTag = hasTag;
        }

        public Builder requiresMaterial(Material<?> material) {
            this.materials.add((Object)material.asStackedIngredient());
            return this.unlockedBy("has_" + material.getName(), material.createTrigger(this.hasItem, this.hasTag));
        }

        public Builder unlockedBy(String name, class_175<?> trigger) {
            this.criteria.put(name, trigger);
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Builder category(class_7800 category) {
            this.category = category;
            return this;
        }

        public Builder showNotification(boolean show) {
            this.showNotification = show;
            return this;
        }

        public class_1792 method_36441() {
            return this.result;
        }

        public void method_17972(class_8790 output, class_2960 id) {
            this.validate(id);
            class_161.class_162 builder = output.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
            output.method_53819(id, (class_1860)new WorkbenchContructingRecipe(this.materials, new class_1799((class_1935)this.result), this.showNotification), builder.method_695(id.method_45138("recipes/" + this.category.method_46203() + "/")));
        }

        private void validate(class_2960 id) {
            if (this.materials.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one material for workbench crafting recipe %s".formatted(id));
            }
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements class_1865<WorkbenchContructingRecipe> {
        public static final MapCodec<WorkbenchContructingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StackedIngredient.CODEC.listOf().fieldOf("materials").flatXmap(materials -> {
            Object[] inputs = (StackedIngredient[])materials.stream().filter(ingredient -> !ingredient.ingredient().method_8103() || ingredient.count() <= 0).toArray(StackedIngredient[]::new);
            return DataResult.success((Object)class_2371.method_10212((Object)StackedIngredient.EMPTY, (Object[])inputs));
        }, DataResult::success).forGetter(o -> o.materials), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)false).forGetter(recipe -> recipe.notification)).apply((Applicative)builder, WorkbenchContructingRecipe::new));
        public static final class_9139<class_9129, WorkbenchContructingRecipe> STREAM_CODEC = class_9139.method_56437((buf, recipe) -> {
            buf.method_53002(recipe.materials.size());
            recipe.materials.forEach(ingredient -> ingredient.toNetwork((class_9129)buf));
            class_1799.field_48349.encode(buf, (Object)recipe.result);
            buf.method_52964(recipe.notification);
        }, buf -> {
            int materialCount = buf.readInt();
            class_2371 materials = class_2371.method_10213((int)materialCount, (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialCount).forEach(i -> materials.set(i, (Object)StackedIngredient.fromNetwork(buf)));
            class_1799 result = (class_1799)class_1799.field_48349.decode(buf);
            boolean notification = buf.readBoolean();
            return new WorkbenchContructingRecipe((class_2371<StackedIngredient>)materials, result, notification);
        });

        public MapCodec<WorkbenchContructingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, WorkbenchContructingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

