/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.heat.Heat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mekanism.api.IContentsListener;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class HeatMachineComponent
extends AbstractMachineComponent
implements ISideConfigComponent,
ITileHeatHandler,
ISerializableComponent,
ISyncableStuff,
ITickableComponent,
IDumpComponent {
    private final double baseTemp;
    private final ToggleSideConfig config;
    private final BasicHeatCapacitor capacitor;
    private final Map<Direction, BlockCapabilityCache<IHeatHandler, Direction>> neighbours = Maps.newEnumMap(Direction.class);
    private double lastEnvironmentalLoss;

    public HeatMachineComponent(IMachineComponentManager manager, double capacity, double baseTemp, double inverseConductionCoefficient, double inverseInsulationCoefficient, ToggleSideConfig.Template config) {
        super(manager, ComponentIOMode.BOTH);
        this.baseTemp = baseTemp;
        this.config = config.build((ISideConfigComponent)this);
        this.config.setCallback(this::onConfigChange);
        this.capacitor = BasicHeatCapacitor.create((double)capacity, (double)inverseConductionCoefficient, (double)inverseInsulationCoefficient, () -> baseTemp, (IContentsListener)this);
    }

    public MachineComponentType<HeatMachineComponent> getType() {
        return Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public ToggleSideConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return "";
    }

    public void serverTick() {
        this.capacitor.update();
        this.updateNeighbours();
        HeatAPI.HeatTransfer transfer = this.simulate();
        this.lastEnvironmentalLoss = transfer.environmentTransfer();
    }

    public void dump(List<String> ids) {
        this.capacitor.setHeat(this.baseTemp);
    }

    public void handleHeatAndUpdate(double heat) {
        this.capacitor.handleHeat(heat);
        this.capacitor.update();
    }

    public double getLastEnvironmentalLoss() {
        return this.lastEnvironmentalLoss;
    }

    private void onConfigChange(RelativeSide side, ToggleSideMode old, ToggleSideMode now) {
        if (old != now) {
            this.getManager().getTile().invalidateCapabilities();
        }
    }

    private void updateNeighbours() {
        Level level = this.getManager().getLevel();
        BlockPos pos = this.getManager().getTile().getBlockPos();
        for (Direction side : Direction.values()) {
            if (this.neighbours.get(side) != null || level.getBlockEntity(pos.relative(side)) == null) continue;
            this.neighbours.put(side, (BlockCapabilityCache<IHeatHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.HEAT, (ServerLevel)((ServerLevel)level), (BlockPos)pos.relative(side), (Object)side.getOpposite(), () -> !this.getManager().getTile().isRemoved(), () -> this.neighbours.remove(side)));
        }
    }

    @Nullable
    public IHeatHandler getHeatHandler(@Nullable Direction side) {
        if (!((ToggleSideMode)this.config.getDirectionMode(side)).isDisabled()) {
            return this;
        }
        return null;
    }

    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putDouble("Heat", this.capacitor.getHeat());
        nbt.put("Config", (Tag)this.config.serialize());
    }

    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("Heat", 6)) {
            this.capacitor.setHeat(nbt.getDouble("Heat"));
        }
        if (nbt.contains("Config", 10)) {
            this.config.deserialize(nbt.getCompound("Config"));
        }
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(DataType.createSyncable(ToggleSideConfig.class, this::getConfig, arg_0 -> ((ToggleSideConfig)this.config).set(arg_0)));
        container.accept(DataType.createSyncable(Double.class, () -> ((BasicHeatCapacitor)this.capacitor).getHeat(), arg_0 -> ((BasicHeatCapacitor)this.capacitor).setHeat(arg_0)));
        container.accept(DataType.createSyncable(Double.class, this::getLastEnvironmentalLoss, loss -> {
            this.lastEnvironmentalLoss = loss;
        }));
    }

    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction direction) {
        if (direction == null || ((ToggleSideMode)this.config.getDirectionMode(direction)).isEnabled()) {
            return Collections.singletonList(this.capacitor);
        }
        return Collections.emptyList();
    }

    public void onContentsChanged() {
        this.getManager().markDirty();
    }

    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        return this.neighbours.get(side) == null ? null : (IHeatHandler)this.neighbours.get(side).getCapability();
    }

    public record Template(double capacity, double baseTemp, double inverseConductionCoefficient, double inverseInsulationCoefficient, ToggleSideConfig.Template config) implements IMachineComponentTemplate<HeatMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.doubleRange((double)1.0, (double)Double.MAX_VALUE).optionalFieldOf("capacity", (Object)1.0).forGetter(template -> template.capacity), (App)NamedCodec.DOUBLE.optionalFieldOf("base_temp", (Object)300.0).forGetter(template -> template.baseTemp), (App)NamedCodec.DOUBLE.optionalFieldOf("conduction", (Object)1.0).forGetter(template -> template.inverseConductionCoefficient), (App)NamedCodec.DOUBLE.optionalFieldOf("insulation", (Object)0.0).forGetter(template -> template.inverseInsulationCoefficient), (App)ToggleSideConfig.Template.CODEC.optionalFieldOf("config", (Object)ToggleSideConfig.Template.DEFAULT_ALL_ENABLED).forGetter(template -> template.config)).apply((Applicative)templateInstance, Template::new), (String)"Heat machine component");

        public MachineComponentType<HeatMachineComponent> getType() {
            return Registration.HEAT_MACHINE_COMPONENT.get();
        }

        public String getId() {
            return "Heat";
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return ingredient instanceof Heat;
        }

        public HeatMachineComponent build(IMachineComponentManager manager) {
            return new HeatMachineComponent(manager, this.capacity, this.baseTemp, this.inverseConductionCoefficient, this.inverseInsulationCoefficient, this.config);
        }
    }
}

