/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.jei.wrapper;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.CMMJeiPlugin;
import fr.frinn.custommachinerymekanism.client.jei.heat.Heat;
import fr.frinn.custommachinerymekanism.client.jei.heat.HeatJEIIngredientRenderer;
import fr.frinn.custommachinerymekanism.common.guielement.HeatGuiElement;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class HeatIngredientWrapper
implements IJEIIngredientWrapper<Heat> {
    private final RequirementIOMode mode;
    private final Heat heat;

    public HeatIngredientWrapper(RequirementIOMode mode, double amount, double chance, boolean isPerTick) {
        this.mode = mode;
        this.heat = new Heat(amount, chance, isPerTick, mode);
    }

    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        HeatGuiElement heatElement;
        block3: {
            block2: {
                if (!(element instanceof HeatGuiElement)) break block2;
                heatElement = (HeatGuiElement)element;
                if (element.getType() == Registration.HEAT_GUI_ELEMENT.get()) break block3;
            }
            return false;
        }
        ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset + 1, element.getY() - yOffset + 1).setCustomRenderer(CMMJeiPlugin.HEAT_INGREDIENT, (IIngredientRenderer)new HeatJEIIngredientRenderer(heatElement)).addIngredient(CMMJeiPlugin.HEAT_INGREDIENT, (Object)this.heat)).addRichTooltipCallback((slot, tooltips) -> {
            if (this.heat.isPerTick()) {
                if (this.heat.mode() == RequirementIOMode.INPUT) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinerymekanism.jei.ingredient.heat.pertick.input", (Object[])new Object[]{this.heat.amount()}));
                } else {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinerymekanism.jei.ingredient.heat.pertick.output", (Object[])new Object[]{this.heat.amount()}));
                }
            } else if (this.heat.mode() == RequirementIOMode.INPUT) {
                tooltips.add((FormattedText)Component.translatable((String)"custommachinerymekanism.jei.ingredient.heat.input", (Object[])new Object[]{this.heat.amount()}));
            } else {
                tooltips.add((FormattedText)Component.translatable((String)"custommachinerymekanism.jei.ingredient.heat.output", (Object[])new Object[]{this.heat.amount()}));
            }
            if (this.heat.chance() == 0.0) {
                tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance.0").withStyle(ChatFormatting.DARK_RED));
            }
            if (this.heat.chance() < 1.0 && this.heat.chance() > 0.0) {
                tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{(int)(this.heat.chance() * 100.0)}));
            }
        });
        return true;
    }
}

