/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class MiscUtil {
    public static <T> Collector<T, ?, List<T>> collectMaxElements(Comparator<? super T> comp) {
        return Collector.of(ArrayList::new, (list, e) -> {
            if (list.isEmpty()) {
                list.add(e);
            } else {
                int c = comp.compare(e, list.get(0));
                if (c == 0) {
                    list.add(e);
                } else if (c > 0) {
                    list.clear();
                    list.add(e);
                }
            }
        }, (list1, list2) -> {
            if (list1.isEmpty()) {
                return list2;
            }
            if (list2.isEmpty()) {
                return list1;
            }
            int c = comp.compare((Object)list1.get(0), (Object)list2.get(0));
            if (c == 0) {
                list1.addAll(list2);
                return list1;
            }
            if (c > 0) {
                return list1;
            }
            return list2;
        }, new Collector.Characteristics[0]);
    }

    public static void spawnServerParticles(ParticleOptions particle, Level level, Vec3 pos, int count, Vec3 spread, double speed) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            slevel.sendParticles(particle, pos.x, pos.y, pos.z, count, spread.x, spread.y, spread.z, speed);
        }
    }

    public static void spawnAlwaysVisibleServerParticles(ParticleOptions particle, Level level, Vec3 pos, int count, Vec3 spread, double speed) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            for (ServerPlayer player : slevel.players()) {
                slevel.sendParticles(player, particle, true, pos.x, pos.y, pos.z, count, spread.x, spread.y, spread.z, speed);
            }
        }
    }

    public static void shrinkItemEntity(ItemEntity entity) {
        entity.getItem().shrink(1);
        if (entity.getItem().isEmpty()) {
            entity.discard();
        }
    }
}

