/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.music;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.init.ModContent;

public class RattleItem
extends Item {
    public RattleItem(Item.Properties props) {
        super(props);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).getCooldowns().isOnCooldown((Item)this)) {
            if (entity.isShiftKeyDown()) {
                TotemicAPI.get().music().playSelector((Entity)entity, ModContent.rattle.get());
            } else {
                TotemicAPI.get().music().playMusic((Entity)entity, ModContent.rattle.get());
            }
            player.getCooldowns().addCooldown((Item)this, 16);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!player.swinging) {
            player.swing(hand, true);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"totemic.tooltip.selectorMode"));
    }
}

