/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.music;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;
import pokefenn.totemic.init.ModItems;

public class JingleDressItem
extends ArmorItem {
    public JingleDressItem(Item.Properties pProperties) {
        super(ModItems.JINGLE_DRESS_MATERIAL, ArmorItem.Type.LEGGINGS, pProperties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        int leggingsSlot = 37;
        if (slotId == 37 && !level.isClientSide && entity instanceof Player && !(player = (Player)entity).isSpectator() && player.tickCount % 20 == 0) {
            double chargeFactor = 10.0;
            int maxSingleCharge = 8;
            int chargeLimit = 10;
            double dx = player.xCloak - player.getX();
            double dy = player.yCloak - player.getY();
            double dz = player.zCloak - player.getZ();
            double velocity = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (player.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                velocity *= 1.2;
            }
            int charge = (Integer)stack.getOrDefault(ModDataComponents.JINGLE_DRESS_CHARGE, (Object)0);
            if ((charge += Mth.clamp((int)((int)(velocity * 10.0)), (int)0, (int)8)) >= 10) {
                TotemicAPI.get().music().playMusic((Entity)player, ModContent.jingle_dress.get());
                charge %= 10;
            }
            stack.set(ModDataComponents.JINGLE_DRESS_CHARGE, (Object)charge);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
    }
}

