/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.music;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.item.music.FluteItem;

public class InfusedFluteItem
extends FluteItem {
    private final Set<Entity> temptedEntities = Collections.newSetFromMap(new WeakHashMap(4));

    public InfusedFluteItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide && !player.isShiftKeyDown()) {
            this.temptEntities(world, player.position());
        }
        return super.use(world, player, hand);
    }

    @Override
    protected int getMusicAmount(RandomSource rand) {
        return ModContent.flute.get().getBaseOutput() + rand.nextInt(120);
    }

    private void temptEntities(Level level, Vec3 pos) {
        level.getEntitiesOfClass(AgeableMob.class, new AABB(pos, pos).inflate(2.0), entity -> (entity instanceof Animal && entity.getNavigation() instanceof GroundPathNavigation || entity instanceof Villager) && !this.temptedEntities.contains(entity)).forEach(entity -> {
            double speed = entity instanceof Animal ? 1.0 : 0.5;
            entity.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)entity, speed, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{this}), false));
            this.temptedEntities.add((Entity)entity);
        });
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

