/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.music;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModItems;

public class FluteItem
extends Item {
    public FluteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            TotemicAPI.get().music().playSelector((Entity)player, ModContent.flute.get());
        } else {
            TotemicAPI.get().music().playMusic(level, player.position(), (Entity)player, ModContent.flute.get(), 5, this.getMusicAmount(level.random));
        }
        player.getCooldowns().addCooldown((Item)ModItems.flute.get(), 20);
        player.getCooldowns().addCooldown((Item)ModItems.infused_flute.get(), 20);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    protected int getMusicAmount(RandomSource rand) {
        return ModContent.flute.get().getBaseOutput();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"totemic.tooltip.selectorMode"));
    }
}

