/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.util.BlockUtil;

public class MedicineBagItem
extends Item {
    public static final int MAX_CHARGE = 4800;

    public MedicineBagItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static TotemCarving getCarving(ItemStack stack) {
        return (TotemCarving)stack.getOrDefault(ModDataComponents.CARVING, (Object)((TotemCarving)ModContent.none.get()));
    }

    public static int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)0);
    }

    public static boolean isOpen(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.OPEN, (Object)false);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        level.getProfiler().push("totemic.medicineBag");
        TotemCarving carving = MedicineBagItem.getCarving(stack);
        if (carving != ModContent.none.get()) {
            long gameTime = level.getGameTime();
            this.tryCharge(stack, level, gameTime, entity.blockPosition());
            if (MedicineBagItem.isOpen(stack)) {
                this.applyEffects(stack, level, gameTime, entity, carving);
            }
        }
        level.getProfiler().pop();
    }

    protected void tryCharge(ItemStack stack, Level level, long gameTime, BlockPos pos) {
        int charge;
        if (!level.isClientSide && gameTime % 20L == 0L && (charge = MedicineBagItem.getCharge(stack)) < 4800) {
            TotemCarving carving = MedicineBagItem.getCarving(stack);
            if (BlockUtil.getBlockEntitiesInRange(ModBlockEntities.totem_base.get(), level, pos, 6).anyMatch(tile -> tile.getTotemState() instanceof StateTotemEffect && tile.hasCarving(carving))) {
                int chargeAmount = 400;
                stack.set(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)Math.min(charge + chargeAmount, 4800));
            }
        }
    }

    protected void applyEffects(ItemStack stack, Level level, long gameTime, Entity entity, TotemCarving carving) {
        int charge = MedicineBagItem.getCharge(stack);
        if (charge > 0) {
            for (TotemEffect effect : carving.getEffects()) {
                if (gameTime % (long)effect.getInterval() != 0L) continue;
                effect.medicineBagEffect((Player)entity, stack, charge);
            }
            if (!level.isClientSide && gameTime % 80L == 0L) {
                stack.set(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)Math.max(charge - carving.getMedicineBagDrain(), 0));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return this.toggleOpen(pPlayer.getItemInHand(pUsedHand), pLevel, pPlayer);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (!ctx.isSecondaryUseActive()) {
            return this.toggleOpen(stack, ctx.getLevel(), ctx.getPlayer()).getResult();
        }
        return this.trySetCarving(stack, ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getHand());
    }

    private InteractionResultHolder<ItemStack> toggleOpen(ItemStack stack, Level level, Player player) {
        if (MedicineBagItem.getCarving(stack) != ModContent.none.get()) {
            stack.update(ModDataComponents.OPEN, (Object)false, open -> open == false);
            level.playLocalSound((Entity)player, (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private InteractionResult trySetCarving(ItemStack stack, Player player, Level level, BlockPos pos, InteractionHand hand) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
            TotemCarving carving = pole.getCarving();
            if (((List)TotemicConfig.SERVER.medicineBagBlacklist.get()).contains(carving.getRegistryName().toString())) {
                player.displayClientMessage((Component)Component.translatable((String)"totemic.medicineBag.blacklisted", (Object[])new Object[]{carving.getDisplayName()}), true);
                return InteractionResult.FAIL;
            }
            if (!carving.supportsMedicineBag()) {
                if (level.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"totemic.medicineBag.notPortable", (Object[])new Object[]{carving.getDisplayName()}), true);
                }
                return InteractionResult.FAIL;
            }
            ItemStack newStack = stack.copy();
            newStack.set(ModDataComponents.CARVING, (Object)carving);
            if (!newStack.is((Item)ModItems.creative_medicine_bag.get())) {
                newStack.set(ModDataComponents.MEDICINE_BAG_CHARGE, (Object)0);
            }
            player.setItemInHand(hand, newStack);
            level.playLocalSound((Entity)player, (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{MedicineBagItem.getCarving(stack).getDisplayName()});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String key = MedicineBagItem.getCarving(stack) != ModContent.none.get() ? (MedicineBagItem.getCharge(stack) > 0 ? (MedicineBagItem.isOpen(stack) ? "open" : "closed") : "empty") : "tooltip";
        tooltip.add((Component)Component.translatable((String)("totemic.medicineBag." + key)));
        if (flag.isAdvanced()) {
            tooltip.add((Component)Component.translatable((String)"totemic.medicineBag.charge", (Object[])new Object[]{MedicineBagItem.getCharge(stack), 4800}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isBarVisible(ItemStack pStack) {
        return true;
    }

    public int getBarWidth(ItemStack pStack) {
        return Math.round(13.0f * (float)MedicineBagItem.getCharge(pStack) / 4800.0f);
    }

    public int getBarColor(ItemStack pStack) {
        float f = (float)MedicineBagItem.getCharge(pStack) / 4800.0f;
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

