/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.init;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.init.ModEntityTypes;

public final class ModDataMapTypes {
    public static final DataMapType<EntityType<?>, EntityType<? extends Mob>> CLEANSING_CEREMONY_CONVERSIONS = DataMapType.builder((ResourceLocation)Totemic.resloc("cleansing_ceremony_conversions"), (ResourceKey)Registries.ENTITY_TYPE, (Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec().comapFlatMap(ModDataMapTypes::checkMobEntityType, Function.identity())).build();

    private static DataResult<EntityType<? extends Mob>> checkMobEntityType(EntityType<?> type) {
        if (type.getCategory() != MobCategory.MISC || type == EntityType.IRON_GOLEM || type == EntityType.SNOW_GOLEM || type == EntityType.VILLAGER || !BuiltInRegistries.ENTITY_TYPE.getKey(type).getNamespace().equals("minecraft") && type != ModEntityTypes.invisible_arrow.get()) {
            return DataResult.success(type);
        }
        return DataResult.error(() -> "Invalid conversion target '" + type.builtInRegistryHolder().getRegisteredName() + "' for the cleasing ceremony, must be a Mob entity type");
    }

    public static void init(RegisterDataMapTypesEvent event) {
        event.register(CLEANSING_CEREMONY_CONVERSIONS);
    }
}

