/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.init;

import com.electronwill.nightconfig.core.Config;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.TotemicBlockTags;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.registry.RegistryAPI;
import pokefenn.totemic.api.totem.PotionTotemEffect;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.ceremony.AnimalGrowthCeremony;
import pokefenn.totemic.ceremony.BaykokSummonCeremony;
import pokefenn.totemic.ceremony.BuffaloDanceCeremony;
import pokefenn.totemic.ceremony.CleansingCeremony;
import pokefenn.totemic.ceremony.DanseMacabreCeremony;
import pokefenn.totemic.ceremony.DepthsCeremony;
import pokefenn.totemic.ceremony.EagleDanceCeremony;
import pokefenn.totemic.ceremony.FertilityCeremony;
import pokefenn.totemic.ceremony.FluteInfusionCeremony;
import pokefenn.totemic.ceremony.SunDanceCeremony;
import pokefenn.totemic.ceremony.WarDanceCeremony;
import pokefenn.totemic.ceremony.WeatherCeremony;
import pokefenn.totemic.ceremony.ZaphkielWaltzCeremony;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.init.ModMobEffects;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.totem.OcelotTotemEffect;

public final class ModContent {
    public static final DeferredRegister<MusicInstrument> INSTRUMENTS = DeferredRegister.create(RegistryAPI.MUSIC_INSTRUMENT_REGISTRY, (String)"totemic");
    public static final Supplier<MusicInstrument> flute = INSTRUMENTS.register("flute", () -> new MusicInstrument(180, 3000).setItem((ItemLike)ModItems.flute.get()).setSound(ModSounds.flute));
    public static final Supplier<MusicInstrument> drum = INSTRUMENTS.register("drum", () -> new MusicInstrument(240, 3300).setItem((ItemLike)ModBlocks.drum.get()).setSound(ModSounds.drum));
    public static final Supplier<MusicInstrument> wind_chime = INSTRUMENTS.register("wind_chime", () -> new MusicInstrument(120, 1500).setItem((ItemLike)ModBlocks.wind_chime.get()).setSound(ModSounds.wind_chime));
    public static final Supplier<MusicInstrument> jingle_dress = INSTRUMENTS.register("jingle_dress", () -> new MusicInstrument(180, 1500).setItem((ItemLike)ModItems.jingle_dress.get()));
    public static final Supplier<MusicInstrument> rattle = INSTRUMENTS.register("rattle", () -> new MusicInstrument(300, 3300).setItem((ItemLike)ModItems.rattle.get()).setSound(ModSounds.rattle));
    public static final Supplier<MusicInstrument> eagle_bone_whistle = INSTRUMENTS.register("eagle_bone_whistle", () -> new MusicInstrument(360, 3600).setItem((ItemLike)ModItems.eagle_bone_whistle.get()).setSound(ModSounds.eagle_bone_whistle));
    public static final DeferredRegister<TotemWoodType> WOOD_TYPES = DeferredRegister.create(RegistryAPI.WOOD_TYPE_REGISTRY, (String)"totemic");
    public static final DeferredHolder<TotemWoodType, TotemWoodType> oak = WOOD_TYPES.register("oak", () -> new TotemWoodType(MapColor.WOOD, MapColor.PODZOL, (TagKey<Block>)BlockTags.OAK_LOGS));
    public static final Supplier<TotemWoodType> spruce = WOOD_TYPES.register("spruce", () -> new TotemWoodType(MapColor.PODZOL, MapColor.COLOR_BROWN, (TagKey<Block>)BlockTags.SPRUCE_LOGS));
    public static final Supplier<TotemWoodType> birch = WOOD_TYPES.register("birch", () -> new TotemWoodType(MapColor.SAND, MapColor.QUARTZ, (TagKey<Block>)BlockTags.BIRCH_LOGS));
    public static final Supplier<TotemWoodType> jungle = WOOD_TYPES.register("jungle", () -> new TotemWoodType(MapColor.DIRT, MapColor.PODZOL, (TagKey<Block>)BlockTags.JUNGLE_LOGS));
    public static final Supplier<TotemWoodType> acacia = WOOD_TYPES.register("acacia", () -> new TotemWoodType(MapColor.COLOR_ORANGE, MapColor.STONE, (TagKey<Block>)BlockTags.ACACIA_LOGS));
    public static final Supplier<TotemWoodType> cherry = WOOD_TYPES.register("cherry", () -> new TotemWoodType(MapColor.TERRACOTTA_WHITE, MapColor.TERRACOTTA_GRAY, (TagKey<Block>)BlockTags.CHERRY_LOGS));
    public static final Supplier<TotemWoodType> dark_oak = WOOD_TYPES.register("dark_oak", () -> new TotemWoodType(MapColor.COLOR_BROWN, MapColor.COLOR_BROWN, (TagKey<Block>)BlockTags.DARK_OAK_LOGS));
    public static final Supplier<TotemWoodType> mangrove = WOOD_TYPES.register("mangrove", () -> new TotemWoodType(MapColor.COLOR_RED, MapColor.PODZOL, (TagKey<Block>)BlockTags.MANGROVE_LOGS));
    public static final Supplier<TotemWoodType> cedar = WOOD_TYPES.register("cedar", () -> new TotemWoodType(MapColor.COLOR_PINK, MapColor.COLOR_ORANGE, TotemicBlockTags.CEDAR_LOGS));
    public static final DeferredRegister<TotemCarving> CARVINGS = DeferredRegister.create(RegistryAPI.TOTEM_CARVING_REGISTRY, (String)"totemic");
    public static final DeferredHolder<TotemCarving, TotemCarving> none = CARVINGS.register("none", () -> TotemCarving.of(new TotemEffect[0]));
    public static final Supplier<TotemCarving> bat = CARVINGS.register("bat", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.SLOW_FALLING)));
    public static final Supplier<TotemCarving> blaze = CARVINGS.register("blaze", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE)));
    public static final Supplier<TotemCarving> buffalo = CARVINGS.register("buffalo", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.DIG_SPEED)));
    public static final Supplier<TotemCarving> cow = CARVINGS.register("cow", () -> TotemCarving.of(new PotionTotemEffect((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE), new PotionTotemEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, false)));
    public static final Supplier<TotemCarving> enderman = CARVINGS.register("enderman", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(MobEffects.NIGHT_VISION, false){

        @Override
        protected int getLingeringTime() {
            return 210;
        }
    }));
    public static final Supplier<TotemCarving> horse = CARVINGS.register("horse", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED)));
    public static final Supplier<TotemCarving> ocelot = CARVINGS.register("ocelot", () -> TotemCarving.of(new OcelotTotemEffect(), new PotionTotemEffect(ModMobEffects.ocelot, false)));
    public static final Supplier<TotemCarving> pig = CARVINGS.register("pig", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.LUCK)));
    public static final Supplier<TotemCarving> rabbit = CARVINGS.register("rabbit", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.JUMP)));
    public static final Supplier<TotemCarving> spider = CARVINGS.register("spider", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect(ModMobEffects.spider)));
    public static final Supplier<TotemCarving> squid = CARVINGS.register("squid", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.WATER_BREATHING)));
    public static final Supplier<TotemCarving> wolf = CARVINGS.register("wolf", () -> TotemCarving.of((TotemEffect)new PotionTotemEffect((Holder<MobEffect>)MobEffects.DAMAGE_BOOST)));
    public static final DeferredRegister<Ceremony> CEREMONIES = DeferredRegister.create(RegistryAPI.CEREMONY_REGISTRY, (String)"totemic");
    public static final Supplier<Ceremony> war_dance = CEREMONIES.register("war_dance", () -> new Ceremony(4500, 400, () -> WarDanceCeremony.INSTANCE, drum, drum));
    public static final Supplier<Ceremony> depths = CEREMONIES.register("depths", () -> new Ceremony(4500, 400, () -> DepthsCeremony.INSTANCE, flute, flute));
    public static final Supplier<Ceremony> fertility = CEREMONIES.register("fertility", () -> new Ceremony(5280, 460, () -> FertilityCeremony.INSTANCE, flute, drum));
    public static final Supplier<Ceremony> zaphkiel_waltz = CEREMONIES.register("zaphkiel_waltz", () -> new Ceremony(6720, 400, () -> ZaphkielWaltzCeremony.INSTANCE, wind_chime, flute));
    public static final Supplier<Ceremony> animal_growth = CEREMONIES.register("animal_growth", () -> new Ceremony(6900, 420, () -> AnimalGrowthCeremony.INSTANCE, flute, wind_chime));
    public static final Supplier<Ceremony> buffalo_dance = CEREMONIES.register("buffalo_dance", () -> new Ceremony(7380, 480, () -> BuffaloDanceCeremony.INSTANCE, drum, wind_chime));
    public static final Supplier<Ceremony> rain = CEREMONIES.register("rain", () -> new Ceremony(10980, 520, () -> WeatherCeremony.RAIN, drum, rattle));
    public static final Supplier<Ceremony> drought = CEREMONIES.register("drought", () -> new Ceremony(10980, 520, () -> WeatherCeremony.DROUGHT, rattle, drum));
    public static final Supplier<Ceremony> flute_infusion = CEREMONIES.register("flute_infusion", () -> new Ceremony(11340, 560, () -> FluteInfusionCeremony.INSTANCE, flute, rattle));
    public static final Supplier<Ceremony> eagle_dance = CEREMONIES.register("eagle_dance", () -> new Ceremony(11580, 500, () -> EagleDanceCeremony.INSTANCE, rattle, wind_chime));
    public static final Supplier<Ceremony> cleansing = CEREMONIES.register("cleansing", () -> new Ceremony(14700, 600, () -> CleansingCeremony.INSTANCE, eagle_bone_whistle, flute));
    public static final Supplier<Ceremony> sun_dance = CEREMONIES.register("sun_dance", () -> new Ceremony(14820, 620, () -> SunDanceCeremony.INSTANCE, drum, eagle_bone_whistle));
    public static final Supplier<Ceremony> danse_macabre = CEREMONIES.register("danse_macabre", () -> new Ceremony(14940, 640, () -> DanseMacabreCeremony.INSTANCE, eagle_bone_whistle, wind_chime));
    public static final Supplier<Ceremony> baykok_summon = CEREMONIES.register("baykok_summon", () -> new Ceremony(15060, 640, () -> BaykokSummonCeremony.INSTANCE, wind_chime, eagle_bone_whistle));

    public static void registerCustomWoodTypes(RegisterEvent event) {
        event.register(RegistryAPI.WOOD_TYPE_REGISTRY, reg -> {
            for (Config entry : (List)TotemicConfig.STARTUP.customTotemWoodTypes.get()) {
                if (entry.isEmpty()) continue;
                String idStr = (String)entry.get("id");
                if (idStr == null) {
                    throw new IllegalArgumentException("Invalid custom Totem Wood Type: Missing entry 'id'. Please check your 'totemic-startup.toml' config file.");
                }
                try {
                    String logsStr = (String)entry.get("logs");
                    if (logsStr == null) {
                        throw new IllegalArgumentException("Missing entry 'logs'");
                    }
                    if (!logsStr.startsWith("#")) {
                        throw new IllegalArgumentException("'logs' value must be a valid block tag key starting with '#'");
                    }
                    int woodColorIndex = entry.getIntOrElse("woodColor", MapColor.WOOD.id);
                    int barkColorIndex = entry.getIntOrElse("barkColor", MapColor.PODZOL.id);
                    ResourceLocation id = ResourceLocation.parse((String)idStr);
                    TagKey logTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)logsStr.substring(1)));
                    MapColor woodColor = MapColor.byId((int)woodColorIndex);
                    MapColor barkColor = MapColor.byId((int)barkColorIndex);
                    reg.register(id, (Object)new TotemWoodType(woodColor, barkColor, (TagKey<Block>)logTagKey));
                    Totemic.logger.debug("Added custom Totem Wood Type with ID '" + String.valueOf(id) + "'");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid custom Totem Wood Type with ID '" + idStr + "': " + e.getLocalizedMessage() + "\nPlease check your 'totemic-startup.toml' config file.", e);
                }
            }
        });
    }
}

