/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.init;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import pokefenn.totemic.block.DummyTipiBlock;
import pokefenn.totemic.block.StrippableLogBlock;
import pokefenn.totemic.block.TipiBlock;
import pokefenn.totemic.block.TotemTorchBlock;
import pokefenn.totemic.block.music.DrumBlock;
import pokefenn.totemic.block.music.WindChimeBlock;
import pokefenn.totemic.block.totem.TotemBaseBlock;
import pokefenn.totemic.block.totem.TotemPoleBlock;
import pokefenn.totemic.init.ModResources;

public final class ModBlocks {
    public static final BlockSetType CEDAR_BLOCK_SET_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("totemic:cedar"));
    public static final WoodType CEDAR_WOOD_TYPE = WoodType.register((WoodType)new WoodType("totemic:cedar", CEDAR_BLOCK_SET_TYPE));
    public static final DeferredRegister.Blocks REGISTER = DeferredRegister.createBlocks((String)"totemic");
    public static final DeferredBlock<RotatedPillarBlock> stripped_cedar_log = REGISTER.register("stripped_cedar_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<StrippableLogBlock> cedar_log = REGISTER.register("cedar_log", () -> new StrippableLogBlock((Supplier<? extends RotatedPillarBlock>)stripped_cedar_log, BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.COLOR_PINK : MapColor.COLOR_ORANGE).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> stripped_cedar_wood = REGISTER.register("stripped_cedar_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<StrippableLogBlock> cedar_wood = REGISTER.register("cedar_wood", () -> new StrippableLogBlock((Supplier<? extends RotatedPillarBlock>)stripped_cedar_wood, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<LeavesBlock> cedar_leaves = REGISTER.register("cedar_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).ignitedByLava().pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((s, g, p, type) -> type == EntityType.OCELOT || type == EntityType.PARROT).isSuffocating((s, g, p) -> false).isViewBlocking((s, g, p) -> false)));
    public static final DeferredBlock<SaplingBlock> cedar_sapling = REGISTER.register("cedar_sapling", () -> new SaplingBlock(new TreeGrower("totemic:cedar", Optional.empty(), Optional.of(ModResources.CEDAR_TREE_FEATURE), Optional.empty()), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).ignitedByLava().pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS)));
    public static final DeferredBlock<Block> cedar_planks = REGISTER.register("cedar_planks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<ButtonBlock> cedar_button = REGISTER.register("cedar_button", () -> new ButtonBlock(CEDAR_BLOCK_SET_TYPE, 30, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<FenceBlock> cedar_fence = REGISTER.register("cedar_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<FenceGateBlock> cedar_fence_gate = REGISTER.register("cedar_fence_gate", () -> new FenceGateBlock(CEDAR_WOOD_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<PressurePlateBlock> cedar_pressure_plate = REGISTER.register("cedar_pressure_plate", () -> new PressurePlateBlock(CEDAR_BLOCK_SET_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<StandingSignBlock> cedar_sign = REGISTER.register("cedar_sign", () -> new StandingSignBlock(CEDAR_WOOD_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<WallSignBlock> cedar_wall_sign = REGISTER.register("cedar_wall_sign", () -> new WallSignBlock(CEDAR_WOOD_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(SoundType.WOOD).lootFrom(cedar_sign)));
    public static final DeferredBlock<CeilingHangingSignBlock> cedar_hanging_sign = REGISTER.register("cedar_hanging_sign", () -> new CeilingHangingSignBlock(CEDAR_WOOD_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava()));
    public static final DeferredBlock<WallHangingSignBlock> cedar_wall_hanging_sign = REGISTER.register("cedar_wall_hanging_sign", () -> new WallHangingSignBlock(CEDAR_WOOD_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).lootFrom(cedar_hanging_sign).ignitedByLava()));
    public static final DeferredBlock<SlabBlock> cedar_slab = REGISTER.register("cedar_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<StairBlock> cedar_stairs = REGISTER.register("cedar_stairs", () -> new StairBlock(((Block)cedar_planks.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)cedar_planks.get()))));
    public static final DeferredBlock<DoorBlock> cedar_door = REGISTER.register("cedar_door", () -> new DoorBlock(CEDAR_BLOCK_SET_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(SoundType.WOOD).noOcclusion()));
    public static final DeferredBlock<TrapDoorBlock> cedar_trapdoor = REGISTER.register("cedar_trapdoor", () -> new TrapDoorBlock(CEDAR_BLOCK_SET_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(SoundType.WOOD).noOcclusion().isValidSpawn((s, g, p, t) -> false)));
    public static final DeferredBlock<FlowerPotBlock> potted_cedar_sapling = REGISTER.register("potted_cedar_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, cedar_sapling, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instabreak().noOcclusion()));
    public static final DeferredBlock<DrumBlock> drum = REGISTER.register("drum", () -> new DrumBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<WindChimeBlock> wind_chime = REGISTER.register("wind_chime", () -> new WindChimeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.5f).sound(SoundType.METAL)));
    public static final DeferredBlock<TotemTorchBlock> totem_torch = REGISTER.register("totem_torch", () -> new TotemTorchBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).strength(0.05f).lightLevel(s -> 15).sound(SoundType.WOOD).noCollission()));
    public static final DeferredBlock<TipiBlock> tipi = REGISTER.register("tipi", () -> new TipiBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).ignitedByLava().strength(0.2f).sound(SoundType.WOOL).noOcclusion()));
    public static final DeferredBlock<DummyTipiBlock> dummy_tipi = REGISTER.register("dummy_tipi", () -> new DummyTipiBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).ignitedByLava().strength(0.2f).sound(SoundType.WOOL).noOcclusion().isValidSpawn((s, g, p, t) -> false).isRedstoneConductor((s, g, p) -> false).isSuffocating((s, g, p) -> false).isViewBlocking((s, g, p) -> false).pushReaction(PushReaction.BLOCK).noLootTable()));
    public static final DeferredBlock<TotemBaseBlock> totem_base = REGISTER.register("totem_base", () -> new TotemBaseBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<TotemPoleBlock> totem_pole = REGISTER.register("totem_pole", () -> new TotemPoleBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));

    public static void addPlantsToFlowerPot() {
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(cedar_sapling.getId(), potted_cedar_sapling);
    }

    public static void setFireInfo() {
        FireBlock fire = (FireBlock)Blocks.FIRE;
        fire.setFlammable((Block)cedar_log.get(), 5, 5);
        fire.setFlammable((Block)stripped_cedar_log.get(), 5, 5);
        fire.setFlammable((Block)cedar_wood.get(), 5, 5);
        fire.setFlammable((Block)stripped_cedar_wood.get(), 5, 5);
        fire.setFlammable((Block)cedar_leaves.get(), 30, 60);
        fire.setFlammable((Block)cedar_planks.get(), 5, 20);
        fire.setFlammable((Block)cedar_fence.get(), 5, 20);
        fire.setFlammable((Block)cedar_fence_gate.get(), 5, 20);
        fire.setFlammable((Block)cedar_slab.get(), 5, 20);
        fire.setFlammable((Block)cedar_stairs.get(), 5, 20);
    }

    public static void addCedarSignToSignBlockEntityType(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.SIGN, new Block[]{(Block)cedar_sign.get(), (Block)cedar_wall_sign.get()});
        event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)cedar_hanging_sign.get(), (Block)cedar_wall_hanging_sign.get()});
    }
}

