/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.advancements.criterion.CeremonyTrigger;
import pokefenn.totemic.api.TotemicItemTags;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModItems;
import vazkii.patchouli.api.PatchouliAPI;

public final class TotemicRecipeProvider
extends RecipeProvider {
    public TotemicRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(pOutput, registries);
    }

    protected void buildRecipes(RecipeOutput rc) {
        ItemStack totempedia = PatchouliAPI.get().getBookStack(Totemic.resloc("totempedia"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)totempedia).pattern("WPW").pattern("WPW").pattern("WPW").define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('W'), ItemTags.LOGS_THAT_BURN).unlockedBy("has_paper", TotemicRecipeProvider.has((ItemLike)Items.PAPER)).unlockedBy("has_totem_knife", TotemicRecipeProvider.has(ModItems.totem_whittling_knife)).save(rc.withConditions(new ICondition[]{new ModLoadedCondition("patchouli")}), "totemic:totempedia");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.flute.get())).pattern(" LS").pattern(" S ").pattern("S  ").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('L'), ItemTags.LEAVES).unlockedBy("has_totem_knife", TotemicRecipeProvider.has(ModItems.totem_whittling_knife)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.jingle_dress.get())).pattern(" L ").pattern("BHB").pattern("LBL").define(Character.valueOf('L'), (ItemLike)ModBlocks.cedar_leaves.get()).define(Character.valueOf('B'), (ItemLike)ModItems.iron_bells.get()).define(Character.valueOf('H'), Tags.Items.LEATHERS).unlockedBy("performed_fertility", TotemicRecipeProvider.performed(ModContent.fertility.get())).unlockedBy("has_cedar_leaves", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.cedar_leaves.get()))).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.iron_bells.get())).pattern(" N ").pattern("NNN").pattern(" N ").define(Character.valueOf('N'), Tags.Items.NUGGETS_IRON).unlockedBy("has_jingle_dress_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)ModItems.jingle_dress.getId())).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.rattle.get())).pattern(" WW").pattern(" BW").pattern("S  ").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), ItemTags.LOGS_THAT_BURN).define(Character.valueOf('B'), (ItemLike)ModItems.buffalo_tooth.get()).unlockedBy("performed_buffalo_dance", TotemicRecipeProvider.performed(ModContent.buffalo_dance.get())).unlockedBy("has_buffalo_tooth", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModItems.buffalo_tooth.get()))).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.totem_whittling_knife.get())).pattern("  I").pattern(" SF").pattern("S  ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), (ItemLike)Items.FLINT).unlockedBy("has_iron_ingot", TotemicRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.totemic_staff.get())).pattern(" LS").pattern(" S ").pattern("S L").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('L'), ItemTags.LEAVES).unlockedBy("has_totem_knife", TotemicRecipeProvider.has(ModItems.totem_whittling_knife)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.drum.get())).pattern("EEE").pattern("LWL").pattern("WLW").define(Character.valueOf('E'), Tags.Items.LEATHERS).define(Character.valueOf('L'), ItemTags.LOGS_THAT_BURN).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy("has_totem_knife", TotemicRecipeProvider.has(ModItems.totem_whittling_knife)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.wind_chime.get())).pattern("WWW").pattern("S S").pattern("C C").define(Character.valueOf('W'), TotemicItemTags.CEDAR_LOGS).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).unlockedBy("performed_fertility", TotemicRecipeProvider.performed(ModContent.fertility.get())).unlockedBy("has_cedar_logs", TotemicRecipeProvider.has(TotemicItemTags.CEDAR_LOGS)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.eagle_bone_whistle.get())).pattern("S ").pattern("BF").define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('B'), (ItemLike)ModItems.eagle_bone.get()).define(Character.valueOf('F'), (ItemLike)ModItems.eagle_feather.get()).unlockedBy("performed_eagle_dance", TotemicRecipeProvider.performed(ModContent.eagle_dance.get())).unlockedBy("has_eagle_bone", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModItems.eagle_bone.get()))).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.medicine_bag.get())).pattern("PST").pattern("HDH").pattern(" H ").define(Character.valueOf('P'), (ItemLike)ModBlocks.cedar_planks.get()).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('T'), (ItemLike)ModItems.buffalo_tooth.get()).define(Character.valueOf('H'), (ItemLike)ModItems.buffalo_hide.get()).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("performed_buffalo_dance", TotemicRecipeProvider.performed(ModContent.buffalo_dance.get())).unlockedBy("has_buffalo_hide", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModItems.buffalo_hide.get()))).unlockedBy("has_buffalo_tooth", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModItems.buffalo_tooth.get()))).save(rc);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LEATHER).requires((ItemLike)ModItems.buffalo_hide.get()).unlockedBy("performed_buffalo_dance", TotemicRecipeProvider.performed(ModContent.buffalo_dance.get())).unlockedBy("has_buffalo_hide", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModItems.buffalo_hide.get()))).save(rc, "totemic:leather_from_hide");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.cedar_planks.get()), (int)4).requires(TotemicItemTags.CEDAR_LOGS).unlockedBy("performed_fertility", TotemicRecipeProvider.performed(ModContent.fertility.get())).unlockedBy("has_cedar_logs", TotemicRecipeProvider.has(TotemicItemTags.CEDAR_LOGS)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.totem_torch.get()), (int)2).pattern("STS").pattern("SWS").pattern(" S ").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), ItemTags.LOGS_THAT_BURN).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_torch", TotemicRecipeProvider.has((ItemLike)Items.TORCH)).save(rc);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.tipi.get())).pattern(" S ").pattern("SWS").pattern("W W").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), ItemTags.WOOL).group("totemic:tipi").unlockedBy("has_wool", TotemicRecipeProvider.has((TagKey)ItemTags.WOOL)).save(rc, "totemic:tipi_from_wool");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.tipi.get())).pattern(" S ").pattern("SWS").pattern("W W").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)ModItems.buffalo_hide.get()).group("totemic:tipi").unlockedBy("performed_buffalo_dance", TotemicRecipeProvider.performed(ModContent.buffalo_dance.get())).unlockedBy("has_buffalo_hide", TotemicRecipeProvider.has((ItemLike)((ItemLike)ModItems.buffalo_hide.get()))).save(rc, "totemic:tipi_from_hide");
        TotemicRecipeProvider.generateRecipes((RecipeOutput)rc, (BlockFamily)TotemicRecipeProvider.createCedarBlockFamily(), (FeatureFlagSet)FeatureFlags.DEFAULT_FLAGS);
        TotemicRecipeProvider.hangingSign((RecipeOutput)rc, (ItemLike)((ItemLike)ModItems.cedar_hanging_sign.get()), (ItemLike)((ItemLike)ModBlocks.stripped_cedar_log.get()));
        TotemicRecipeProvider.woodFromLogs((RecipeOutput)rc, (ItemLike)((ItemLike)ModBlocks.cedar_wood.get()), (ItemLike)((ItemLike)ModBlocks.cedar_log.get()));
        TotemicRecipeProvider.woodFromLogs((RecipeOutput)rc, (ItemLike)((ItemLike)ModBlocks.stripped_cedar_wood.get()), (ItemLike)((ItemLike)ModBlocks.stripped_cedar_log.get()));
        TotemicRecipeProvider.simpleCookingRecipe((RecipeOutput)rc, (String)"smelting", (RecipeSerializer)RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (int)200, (ItemLike)((ItemLike)ModItems.buffalo_meat.get()), (ItemLike)((ItemLike)ModItems.cooked_buffalo_meat.get()), (float)0.35f);
        TotemicRecipeProvider.simpleCookingRecipe((RecipeOutput)rc, (String)"smoking", (RecipeSerializer)RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, (int)100, (ItemLike)((ItemLike)ModItems.buffalo_meat.get()), (ItemLike)((ItemLike)ModItems.cooked_buffalo_meat.get()), (float)0.35f);
        TotemicRecipeProvider.simpleCookingRecipe((RecipeOutput)rc, (String)"campfire_cooking", (RecipeSerializer)RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, (int)600, (ItemLike)((ItemLike)ModItems.buffalo_meat.get()), (ItemLike)((ItemLike)ModItems.cooked_buffalo_meat.get()), (float)0.35f);
    }

    private static BlockFamily createCedarBlockFamily() {
        return new BlockFamily.Builder((Block)ModBlocks.cedar_planks.get()).button((Block)ModBlocks.cedar_button.get()).fence((Block)ModBlocks.cedar_fence.get()).fenceGate((Block)ModBlocks.cedar_fence_gate.get()).pressurePlate((Block)ModBlocks.cedar_pressure_plate.get()).sign((Block)ModBlocks.cedar_sign.get(), (Block)ModBlocks.cedar_wall_sign.get()).slab((Block)ModBlocks.cedar_slab.get()).stairs((Block)ModBlocks.cedar_stairs.get()).door((Block)ModBlocks.cedar_door.get()).trapdoor((Block)ModBlocks.cedar_trapdoor.get()).recipeGroupPrefix("totemic:wooden").recipeUnlockedBy("has_planks").getFamily();
    }

    public static Criterion<CeremonyTrigger.TriggerInstance> performed(Ceremony ceremony) {
        return CeremonyTrigger.TriggerInstance.performedCeremony(ceremony);
    }
}

