/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.event.CeremonyEvent;
import pokefenn.totemic.compat.kubejs.CeremonyKubeEvent;
import pokefenn.totemic.compat.kubejs.ModifyCeremoniesKubeEvent;
import pokefenn.totemic.compat.kubejs.ModifyMusicInstrumentsKubeEvent;
import pokefenn.totemic.compat.kubejs.ModifyTotemCarvingsKubeEvent;
import pokefenn.totemic.compat.kubejs.TotemicKubeJSEvents;

public class TotemicKubeEventHandler {
    public static void postModificationEvents() {
        TotemicKubeJSEvents.modifyMusicInstruments.post((KubeEvent)new ModifyMusicInstrumentsKubeEvent());
        TotemicKubeJSEvents.modifyTotemCarvings.post((KubeEvent)new ModifyTotemCarvingsKubeEvent());
        TotemicKubeJSEvents.modifyCeremonies.post((KubeEvent)new ModifyCeremoniesKubeEvent());
    }

    @SubscribeEvent
    public static void onCeremonySelection(CeremonyEvent.Selection event) {
        EventResult result;
        ResourceKey key = event.getCeremony().map(Ceremony::getResourceKey).orElse(null);
        if (TotemicKubeJSEvents.ceremonySelection.hasListeners((Object)key) && (result = TotemicKubeJSEvents.ceremonySelection.post((KubeEvent)new CeremonyKubeEvent.Selection(event), (Object)key)).interruptFalse()) {
            event.setCeremony(null);
        }
    }

    @SubscribeEvent
    public static void onCeremonyStartupTick(CeremonyEvent.StartupTick event) {
        ResourceKey<Ceremony> key = event.getCeremony().getResourceKey();
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (TotemicKubeJSEvents.ceremonyStartupTick.hasListeners(key)) {
                TotemicKubeJSEvents.ceremonyStartupTick.post((ScriptTypeHolder)level, key, (KubeEvent)new CeremonyKubeEvent.StartupTick(event)).applyCancel((ICancellableEvent)event);
            }
        }
    }

    @SubscribeEvent
    public static void onCeremonyStartupFail(CeremonyEvent.StartupFail event) {
        ResourceKey<Ceremony> key = event.getCeremony().getResourceKey();
        if (TotemicKubeJSEvents.ceremonyStartupFail.hasListeners(key)) {
            TotemicKubeJSEvents.ceremonyStartupFail.post((KubeEvent)new CeremonyKubeEvent.StartupFail(event), key);
        }
    }

    @SubscribeEvent
    public static void onCeremonyStartupSuccess(CeremonyEvent.StartupSuccess event) {
        ResourceKey<Ceremony> key = event.getCeremony().getResourceKey();
        if (TotemicKubeJSEvents.ceremonyStartupSuccess.hasListeners(key)) {
            TotemicKubeJSEvents.ceremonyStartupSuccess.post((KubeEvent)new CeremonyKubeEvent.StartupSuccess(event), key).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void onCeremonyEffectTick(CeremonyEvent.EffectTick event) {
        ResourceKey<Ceremony> key = event.getCeremony().getResourceKey();
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (TotemicKubeJSEvents.ceremonyEffectTick.hasListeners(key)) {
                TotemicKubeJSEvents.ceremonyEffectTick.post((ScriptTypeHolder)level, key, (KubeEvent)new CeremonyKubeEvent.EffectTick(event)).applyCancel((ICancellableEvent)event);
            }
        }
    }
}

