/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import pokefenn.totemic.api.totem.PotionTotemEffect;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;

@ReturnsSelf
public class TotemCarvingBuilder
extends BuilderBase<TotemCarving> {
    public final transient List<TotemEffect> effects = new ArrayList<TotemEffect>();
    public transient int medicineBagDrain = 80;

    public TotemCarvingBuilder(ResourceLocation id) {
        super(id);
    }

    public TotemCarving createObject() {
        return TotemCarving.of(this.effects).setMedicineBagDrain(this.medicineBagDrain);
    }

    @Info(value="Adds an effect to the carving")
    public TotemCarvingBuilder effect(TotemEffect effect) {
        this.effects.add(effect);
        return this;
    }

    @Info(value="Adds a potion effect (`TotemEffect.potion(...)`) to the carving")
    public TotemCarvingBuilder potion(Holder<MobEffect> mobEffect) {
        return this.effect(new PotionTotemEffect(mobEffect));
    }

    @Info(value="Sets the amount of charge to drain from a Medicine Bag every 80 ticks (regardless of the effects' intervals).")
    public TotemCarvingBuilder medicineBagDrain(int drain) {
        this.medicineBagDrain = drain;
        return this;
    }

    public String getTranslationKeyGroup() {
        return "totemic.totem";
    }
}

