/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import pokefenn.totemic.api.music.MusicInstrument;

@ReturnsSelf
public class MusicInstrumentBuilder
extends BuilderBase<MusicInstrument> {
    public transient int baseOutput = -1;
    public transient int musicMaximum = -1;
    public transient ItemStack displayItem = ItemStack.EMPTY;
    @Nullable
    public transient Supplier<SoundEvent> sound = null;

    public MusicInstrumentBuilder(ResourceLocation id) {
        super(id);
    }

    public MusicInstrument createObject() {
        if (this.baseOutput < 0) {
            throw new KubeRuntimeException("baseOutput not set for Music Instrument '" + String.valueOf(this.id) + "'").source(this.sourceLine);
        }
        if (this.musicMaximum < 0) {
            throw new KubeRuntimeException("musicMaximum not set for Music Instrument '" + String.valueOf(this.id) + "'").source(this.sourceLine);
        }
        return new MusicInstrument(this.baseOutput, this.musicMaximum).setItem(this.displayItem).setSound(this.sound);
    }

    @Info(value="Sets the default music output when the instrument is played. The instrument's actual music output may differ\nfrom this value, as given by the parameters to `TotemicAPI.music().playMusic()`.\n")
    public MusicInstrumentBuilder baseOutput(int baseOutput) {
        this.baseOutput = baseOutput;
        return this;
    }

    @Info(value="Sets the maximum amount of music that a Totem Base can receive from this instrument before getting saturated.\n")
    public MusicInstrumentBuilder musicMaximum(int musicMaximum) {
        this.musicMaximum = musicMaximum;
        return this;
    }

    @Info(value="Sets the item stack that is associated with this instrument.\n\nNote that this value is only used for display purposes. In order to have an item actually play music,\nyou need to call `TotemicAPI.music().playMusic()` and `playSelector()`, for example from a `use` callback.\n")
    public MusicInstrumentBuilder displayItem(ItemStack item) {
        this.displayItem = item;
        return this;
    }

    @Info(value="Sets the sound associated with this instrument. May be `null`, in which case no sound will be played.")
    public MusicInstrumentBuilder sound(@Nullable SoundEvent sound) {
        this.sound = sound != null ? () -> sound : null;
        return this;
    }

    public String getTranslationKeyGroup() {
        return "totemic.instrument";
    }
}

