/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;

public class ModifyTotemCarvingsKubeEvent
implements KubeEvent {
    @Info(value="Modifies the given Totem Carving.")
    public void modify(TotemCarving carving, Consumer<TotemCarvingModification> c) {
        TotemCarvingModification mod = new TotemCarvingModification(this, carving);
        c.accept(mod);
        if (mod.effectList != null) {
            carving.setEffects(mod.effectList);
        }
    }

    public class TotemCarvingModification {
        private final TotemCarving carving;
        private List<TotemEffect> effectList = null;

        public TotemCarvingModification(ModifyTotemCarvingsKubeEvent this$0, TotemCarving carving) {
            this.carving = carving;
        }

        @Info(value="Returns the carving's effects.")
        public List<TotemEffect> getEffects() {
            if (this.effectList == null) {
                this.effectList = new ArrayList<TotemEffect>(this.carving.getEffects());
            }
            return this.effectList;
        }

        @Info(value="Sets the carving's effects.")
        public void setEffects(List<TotemEffect> effects) {
            this.effectList = Objects.requireNonNull(effects);
        }

        @Info(value="Returns how much charge is drained from a Medicine Bag every 80 ticks (regardless of the effects' intervals).")
        public int getMedicineBagDrain() {
            return this.carving.getMedicineBagDrain();
        }

        @Info(value="Sets the amount of charge to drain from a Medicine Bag every 80 ticks (regardless of the effects' intervals).")
        public void setMedicineBagDrain(int drain) {
            this.carving.setMedicineBagDrain(drain);
        }
    }
}

