/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.List;
import java.util.function.Consumer;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;

public class ModifyCeremoniesKubeEvent
implements KubeEvent {
    @Info(value="Modifies the given Ceremony.\n")
    public void modify(Ceremony ceremony, Consumer<CeremonyModification> c) {
        c.accept(new CeremonyModification(ceremony));
    }

    public record CeremonyModification(Ceremony ceremony) {
        @Info(value="Returns the amount of music needed to start the ceremony.\n\nThis value determines which Music Instruments are necessary to successfully perform this ceremony, and should\nbe modified with care.\n")
        public int getMusicNeeded() {
            return this.ceremony.getMusicNeeded();
        }

        @Info(value="Changes the amount of music needed to start the ceremony.\n\nThis value determines which Music Instruments are necessary to successfully perform this ceremony, and should\nbe modified with care.\n")
        public void setMusicNeeded(int musicNeeded) {
            this.ceremony.setMusicNeeded(musicNeeded);
        }

        @Info(value="Returns the maximum time in ticks that the player may take to start the ceremony.\n\nThis value will be adjusted depending on the level's difficulty.\n")
        public int getMaxStartupTime() {
            return this.ceremony.getMaxStartupTime();
        }

        @Info(value="Changes the maximum time in ticks that the player may take to start the ceremony.\n\nThis value will be adjusted depending on the level's difficulty.\n")
        public void setMaxStartupTime(int maxStartupTime) {
            this.ceremony.setMaxStartupTime(maxStartupTime);
        }

        @Info(value="Changes the ceremony's selecting instruments.")
        public void setSelectors(List<MusicInstrument> selectors) {
            this.ceremony.setSelectors(selectors);
        }
    }
}

