/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.block.music.entity.WindChimeBlockEntity;
import pokefenn.totemic.client.ModModelLayers;

public class WindChimeRenderer
implements BlockEntityRenderer<WindChimeBlockEntity> {
    private static final ResourceLocation TEXTURE = Totemic.resloc("textures/entity/wind_chime.png");
    private final ModelPart root;

    public WindChimeRenderer(BlockEntityRendererProvider.Context pContext) {
        this.root = pContext.bakeLayer(ModModelLayers.WIND_CHIME);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 7.0f, 1.0f, 7.0f, true), PartPose.offset((float)-3.5f, (float)10.0f, (float)-3.5f));
        root.addOrReplaceChild("chime1", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 2.0f, -1.0f, 2.0f, 8.0f, 2.0f, true), PartPose.offset((float)0.0f, (float)11.0f, (float)-2.5f));
        root.addOrReplaceChild("chime2", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 2.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.offset((float)-2.5f, (float)11.0f, (float)0.0f));
        root.addOrReplaceChild("chime3", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 2.0f, -1.0f, 2.0f, 7.0f, 2.0f, true), PartPose.offset((float)0.0f, (float)11.0f, (float)2.5f));
        root.addOrReplaceChild("chime4", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 2.0f, -1.0f, 2.0f, 11.0f, 2.0f, true), PartPose.offset((float)2.5f, (float)11.0f, (float)0.0f));
        root.addOrReplaceChild("connector1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offset((float)0.0f, (float)11.0f, (float)2.5f));
        root.addOrReplaceChild("connector2", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offset((float)-2.5f, (float)11.0f, (float)0.0f));
        root.addOrReplaceChild("connector3", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offset((float)0.0f, (float)11.0f, (float)-2.5f));
        root.addOrReplaceChild("connector4", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, true), PartPose.offset((float)2.5f, (float)11.0f, (float)0.0f));
        root.addOrReplaceChild("hook", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, true), PartPose.offset((float)-0.5f, (float)8.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void render(WindChimeBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 1.5, 0.5);
        pPoseStack.mulPose(new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f));
        VertexConsumer buffer = pBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
        this.root.render(pPoseStack, buffer, pPackedLight, pPackedOverlay);
        pPoseStack.popPose();
    }
}

