/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model.totem;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.client.model.totem.BakedTotemPoleModel;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;

public final class TotemPoleModel
implements IUnbakedGeometry<TotemPoleModel> {
    private Map<TotemPoleModelData, UnbakedModel> totemModels = null;

    private TotemPoleModel() {
    }

    public BakedModel bake(IGeometryBakingContext ctx, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        Map<TotemPoleModelData, BakedModel> bakedModels = Map.copyOf(Maps.transformValues(this.totemModels, unbaked -> unbaked.bake(bakery, spriteGetter, modelState)));
        return new BakedTotemPoleModel(bakedModels);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext ctx) {
        if (this.totemModels == null) {
            DefaultedRegistry<TotemWoodType> woodTypeRegistry = TotemicAPI.get().registry().woodTypes();
            DefaultedRegistry<TotemCarving> carvingRegistry = TotemicAPI.get().registry().totemCarvings();
            this.totemModels = Maps.newHashMapWithExpectedSize((int)(woodTypeRegistry.size() * carvingRegistry.size()));
            for (TotemWoodType woodType : woodTypeRegistry) {
                BlockModel woodTypeModel = (BlockModel)modelGetter.apply(TotemPoleModel.getWoodTypeModelName(woodType));
                if (woodTypeModel.getParentLocation() != null) {
                    Totemic.logger.error("Error loading {}: Parents are not supported for Totem Wood Type models", (Object)woodTypeModel);
                }
                Map textureMap = woodTypeModel.textureMap;
                for (TotemCarving carving : carvingRegistry) {
                    BlockModel model = new BlockModel(TotemPoleModel.getPoleModelName(carving), List.of(), textureMap, Boolean.valueOf(ctx.useAmbientOcclusion()), null, ctx.getTransforms(), List.of());
                    model.name = ctx.getModelName() + "[" + String.valueOf(woodType.getRegistryName()) + ", " + String.valueOf(carving.getRegistryName()) + "]";
                    this.totemModels.put(new TotemPoleModelData(woodType, carving), (UnbakedModel)model);
                    model.resolveParents(modelGetter);
                }
            }
        }
    }

    private static ResourceLocation getWoodTypeModelName(TotemWoodType woodType) {
        ResourceLocation woodName = woodType.getRegistryName();
        return woodName.withPath("block/" + woodName.getPath() + "_totem_pole");
    }

    private static ResourceLocation getPoleModelName(TotemCarving carving) {
        ResourceLocation carvingName = carving.getRegistryName();
        return carvingName.withPath("block/totem_pole_" + carvingName.getPath());
    }

    public static enum Loader implements IGeometryLoader<TotemPoleModel>
    {
        INSTANCE;


        public TotemPoleModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new TotemPoleModel();
        }
    }
}

