/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model.totem;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.item.TotemPoleItem;

public final class BakedTotemBaseModel
extends BakedModelWrapper<BakedModel> {
    private final Map<TotemWoodType, BakedModel> bakedTotemModels;
    private final ItemOverrides itemOverrides;

    BakedTotemBaseModel(final Map<TotemWoodType, BakedModel> bakedTotemModels) {
        super(Objects.requireNonNull(bakedTotemModels.get(ModContent.oak.get())));
        this.bakedTotemModels = bakedTotemModels;
        this.itemOverrides = new ItemOverrides(this){

            public BakedModel resolve(BakedModel pModel, ItemStack pStack, ClientLevel pLevel, LivingEntity pEntity, int pSeed) {
                return (BakedModel)bakedTotemModels.get(TotemPoleItem.getWoodType(pStack));
            }
        };
    }

    private BakedModel getModelFor(ModelData modelData) {
        TotemWoodType woodType = Objects.requireNonNullElse((TotemWoodType)modelData.get(TotemPoleModelData.WOOD_TYPE_PROPERTY), (TotemWoodType)ModContent.oak.get());
        return this.bakedTotemModels.get(woodType);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        return this.getModelFor(extraData).getQuads(state, side, rand, extraData, renderType);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.getModelFor(data).getParticleIcon(data);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.getModelFor(data).getRenderTypes(state, rand, data);
    }

    public ItemOverrides getOverrides() {
        return this.itemOverrides;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        return modelData;
    }
}

