/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateCeremonyEffect;
import pokefenn.totemic.block.totem.entity.StateSelection;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;

public enum CeremonyHUD implements LayeredDraw.Layer
{
    INSTANCE;

    private static final ResourceLocation SELECTION_HUD_TEXTURE;
    private static final ResourceLocation CEREMONY_HUD_TEXTURE;
    private static final Component SELECTION_TEXT;
    private static final int HUD_WIDTH = 117;
    private static final int HUD_HEIGHT = 30;
    private TotemBaseBlockEntity activeTotem = null;

    public void setActiveTotem(TotemBaseBlockEntity tile) {
        double hudRange = 8.0;
        if (tile.getBlockPos().distToCenterSqr((Position)Minecraft.getInstance().getCameraEntity().position()) <= 64.0) {
            this.activeTotem = tile;
        } else if (this.activeTotem == tile) {
            this.activeTotem = null;
        }
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (this.activeTotem == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.getProfiler().push("totemic.ceremonyHUD");
        if (this.activeTotem.isRemoved() || this.activeTotem.getLevel() != mc.level || this.activeTotem.getTotemState() instanceof StateTotemEffect) {
            this.activeTotem = null;
            mc.getProfiler().pop();
            return;
        }
        int hudX = (guiGraphics.guiWidth() - 117) / 2 + (Integer)TotemicConfig.CLIENT.ceremonyHudPositionX.get();
        int hudY = (guiGraphics.guiHeight() - 30) / 2 + (Integer)TotemicConfig.CLIENT.ceremonyHudPositionY.get();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)hudX, (float)hudY, 0.0f);
        RenderSystem.enableBlend();
        TotemState state = this.activeTotem.getTotemState();
        if (state instanceof StateSelection) {
            StateSelection s = (StateSelection)state;
            this.renderSelectionHUD(s, guiGraphics, deltaTracker);
        } else if (state instanceof StateStartup) {
            StateStartup s = (StateStartup)state;
            this.renderStartupHUD(s, guiGraphics, deltaTracker);
        } else if (state instanceof StateCeremonyEffect) {
            StateCeremonyEffect s = (StateCeremonyEffect)state;
            this.renderCeremonyEffectHUD(s, guiGraphics, deltaTracker);
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
        mc.getProfiler().pop();
    }

    private void renderSelectionHUD(StateSelection state, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int texW = 128;
        int texH = 64;
        guiGraphics.blit(SELECTION_HUD_TEXTURE, 0, 0, 0.0f, 0.0f, 117, 30, 128, 64);
        Font font = Minecraft.getInstance().font;
        int headerX = (117 - font.width((FormattedText)SELECTION_TEXT)) / 2;
        guiGraphics.drawString(font, SELECTION_TEXT, headerX, 2, -939524096, false);
        List<MusicInstrument> selectors = state.getSelectors();
        if (!selectors.isEmpty()) {
            ItemStack item = selectors.get(0).getItem();
            guiGraphics.renderItem(item, 40, 12);
        }
    }

    private void renderStartupHUD(StateStartup state, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int texW = 128;
        int texH = 64;
        int barW = 104;
        int barH = 7;
        Ceremony cer = state.getCeremony();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CEREMONY_HUD_TEXTURE);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        PoseStack poseStack = guiGraphics.pose();
        CeremonyHUD.addQuad(buf, poseStack, 0.0f, 0.0f, 117.0f, 30.0f, 0.0f, 0.0f, 117.0f, 30.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 1.0f, 10.0f, 9.0f, 9.0f, 16.0f, 48.0f, 8.0f, 8.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 1.0f, 20.0f, 9.0f, 9.0f, 0.0f, 48.0f, 16.0f, 16.0f, 128, 64);
        float musicW = (float)state.getTotalMusic() / (float)cer.getMusicNeeded() * 104.0f;
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        float timeW = Math.min(((float)state.getTime() + partialTick) / (float)cer.getAdjustedMaxStartupTime(Minecraft.getInstance().level.getDifficulty()), 1.0f) * 104.0f;
        CeremonyHUD.addQuad(buf, poseStack, 11.0f, 11.0f, musicW, 7.0f, 0.0f, 32.0f, musicW, 7.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 11.0f, 21.0f, timeW, 7.0f, 0.0f, 32.0f, timeW, 7.0f, 128, 64);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        MutableComponent name = cer.getDisplayName();
        Font font = Minecraft.getInstance().font;
        int nameX = (117 - font.width((FormattedText)name)) / 2;
        guiGraphics.drawString(font, (Component)name, nameX, 2, -939524096, false);
    }

    private void renderCeremonyEffectHUD(StateCeremonyEffect state, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int texW = 128;
        int texH = 64;
        int barW = 104;
        int barH = 7;
        Ceremony cer = state.getCeremony();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CEREMONY_HUD_TEXTURE);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        PoseStack poseStack = guiGraphics.pose();
        CeremonyHUD.addQuad(buf, poseStack, 0.0f, 0.0f, 117.0f, 30.0f, 0.0f, 0.0f, 117.0f, 30.0f, 128, 64);
        CeremonyHUD.addQuad(buf, poseStack, 1.0f, 20.0f, 9.0f, 9.0f, 0.0f, 48.0f, 16.0f, 16.0f, 128, 64);
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        float timeW = Mth.clamp((float)(1.0f - ((float)state.getTime() + partialTick) / (float)state.getEffectTime()), (float)0.0f, (float)1.0f) * 104.0f;
        CeremonyHUD.addQuad(buf, poseStack, 11.0f, 21.0f, timeW, 7.0f, 0.0f, 32.0f, timeW, 7.0f, 128, 64);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        MutableComponent name = cer.getDisplayName();
        Font font = Minecraft.getInstance().font;
        int nameX = (117 - font.width((FormattedText)name)) / 2;
        guiGraphics.drawString(font, (Component)name, nameX, 2, -939524096, false);
    }

    private static void addQuad(BufferBuilder buf, PoseStack ps, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        Matrix4f mat = ps.last().pose();
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + uWidth) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + vHeight) / (float)textureHeight;
        buf.addVertex(mat, x, y + height, 0.0f).setUv(minU, maxV);
        buf.addVertex(mat, x + width, y + height, 0.0f).setUv(maxU, maxV);
        buf.addVertex(mat, x + width, y, 0.0f).setUv(maxU, minV);
        buf.addVertex(mat, x, y, 0.0f).setUv(minU, minV);
    }

    static {
        SELECTION_HUD_TEXTURE = Totemic.resloc("textures/gui/selection_hud.png");
        CEREMONY_HUD_TEXTURE = Totemic.resloc("textures/gui/ceremony_hud.png");
        SELECTION_TEXT = Component.translatable((String)"totemic.hud.selection");
    }
}

