/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicBlockTags;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;

public enum ZaphkielWaltzCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RADIUS = 6;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (context.getTime() % 7 == 0) {
            TotemicAPI.get().ceremony().forEachBlockIn(level, TotemicEntityUtil.getBoundingBoxAround(pos, 6), (p, state) -> {
                if (state.isRandomlyTicking() && state.is(TotemicBlockTags.ZAPHKIEL_WALTZ_GROWABLE) && level.random.nextInt(4) < 3) {
                    if (!level.isClientSide) {
                        state.randomTick((ServerLevel)level, p, level.random);
                    } else {
                        this.spawnParticles(level, (BlockPos)p);
                    }
                }
            });
        }
    }

    @Override
    public int getEffectTime() {
        return 900;
    }

    private void spawnParticles(Level level, BlockPos pos) {
        RandomSource rand = level.random;
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos).add(rand.nextGaussian() * 0.5, rand.nextGaussian() * 0.5, rand.nextGaussian() * 0.5);
        double ySpeed = rand.nextGaussian();
        level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, vec.x, vec.y, vec.z, 0.0, ySpeed, 0.0);
    }
}

