/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.util.MiscUtil;

public enum DanseMacabreCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RANGE = 6;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (!level.isClientSide && context.getTime() % 20 == 0) {
            level.getEntities((EntityTypeTest)EntityType.ITEM, TotemicEntityUtil.getAABBAround(pos, 6.0), e -> e.getItem().is(Items.ROTTEN_FLESH)).forEach(item -> {
                if (level.random.nextInt(4) == 0) {
                    this.summonZombie(level, (ItemEntity)item);
                }
            });
        }
    }

    private void summonZombie(Level level, ItemEntity item) {
        BlockPos pos = BlockPos.containing((Position)item.position());
        if (!level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty() || !level.getBlockState(pos.above()).getCollisionShape((BlockGetter)level, pos).isEmpty()) {
            return;
        }
        LivingEntity zombie = level.dimension() == Level.NETHER ? (LivingEntity)EntityType.ZOMBIFIED_PIGLIN.create(level) : (level.random.nextInt(10) == 0 ? (LivingEntity)EntityType.ZOMBIE_VILLAGER.create(level) : (level.getFluidState(pos).is(FluidTags.WATER) ? (LivingEntity)EntityType.DROWNED.create(level) : (level.getBiome(pos).is(Biomes.DESERT) ? (LivingEntity)EntityType.HUSK.create(level) : (LivingEntity)EntityType.ZOMBIE.create(level))));
        if (zombie == null) {
            return;
        }
        double dx = 0.25 * level.random.nextGaussian();
        double dz = 0.25 * level.random.nextGaussian();
        float yRot = 360.0f * level.random.nextFloat();
        zombie.moveTo(item.getX() + dx, item.getY(), item.getZ() + dz, yRot, item.getXRot());
        zombie.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 2));
        zombie.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 2));
        MiscUtil.shrinkItemEntity(item);
        level.addFreshEntity((Entity)zombie);
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, level, zombie.getBoundingBox().getCenter(), 24, new Vec3(0.6, 0.5, 0.6), 0.0);
    }

    @Override
    public int getEffectTime() {
        return 900;
    }

    @Override
    public boolean canSelect(Level level, BlockPos pos, Entity initiator) {
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            initiator.sendSystemMessage((Component)Component.translatable((String)"totemic.cantUseDanseMacabreOnPeaceful"));
            return false;
        }
        return true;
    }
}

