/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateCeremonyEffect;
import pokefenn.totemic.block.totem.entity.StateSelection;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.util.MiscUtil;

public abstract sealed class TotemState
implements MusicAcceptor
permits StateTotemEffect, StateSelection, StateStartup, StateCeremonyEffect {
    final TotemBaseBlockEntity tile;

    TotemState(TotemBaseBlockEntity tile) {
        this.tile = tile;
    }

    public abstract void tick();

    public boolean canSelect() {
        return false;
    }

    public void addSelector(Entity entity, MusicInstrument instr) {
    }

    @Override
    public Vec3 getPosition() {
        return Vec3.atCenterOf((Vec3i)this.tile.getBlockPos());
    }

    public int getAnalogOutputSignal() {
        return 0;
    }

    void resetTotemState() {
        if (this.tile.getLevel().isClientSide) {
            return;
        }
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.tile.getLevel(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.tile.setTotemState(new StateTotemEffect(this.tile));
    }

    static TotemState fromID(byte id, TotemBaseBlockEntity tile) {
        return switch (id) {
            case 0 -> new StateTotemEffect(tile);
            case 1 -> new StateSelection(tile);
            case 2 -> new StateStartup(tile);
            case 3 -> new StateCeremonyEffect(tile);
            default -> throw new IllegalArgumentException("Invalid Totem state");
        };
    }

    abstract byte getID();

    abstract void save(CompoundTag var1, HolderLookup.Provider var2);

    abstract void load(CompoundTag var1, HolderLookup.Provider var2);
}

