/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicCapabilities;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;

public class TotemBaseBlockEntity
extends BlockEntity {
    private boolean needPoleUpdate = true;
    private ResourceLocation woodTypeLoc = ModContent.oak.getId();
    private volatile TotemWoodType woodType = (TotemWoodType)ModContent.oak.get();
    private final List<TotemCarving> carvingList = new ArrayList<TotemCarving>(5);
    private Set<TotemCarving> carvingSet = null;
    private Multiset<TotemEffect> totemEffects = ImmutableMultiset.of();
    private int commonTotemEffectInterval = Integer.MAX_VALUE;
    private TotemState state = new StateTotemEffect(this);

    public TotemBaseBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.totem_base.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, TotemBaseBlockEntity tile) {
        if (tile.needPoleUpdate) {
            tile.calculateTotemEffects();
            tile.needPoleUpdate = false;
        }
        tile.state.tick();
    }

    private void calculateTotemEffects() {
        BlockEntity blockEntity;
        this.carvingList.clear();
        this.carvingSet = null;
        ImmutableMultiset.Builder totemEffectsBuilder = ImmutableMultiset.builder();
        for (int i = 0; i < 5 && (blockEntity = this.level.getBlockEntity(this.worldPosition.above(i + 1))) instanceof TotemPoleBlockEntity; ++i) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
            TotemCarving carving = pole.getCarving();
            this.carvingList.add(carving);
            totemEffectsBuilder.addAll(carving.getEffects());
        }
        this.totemEffects = totemEffectsBuilder.build();
        this.commonTotemEffectInterval = this.totemEffects.elementSet().stream().mapToInt(TotemEffect::getInterval).reduce(IntMath::gcd).orElse(Integer.MAX_VALUE);
    }

    public void onPoleChange() {
        this.needPoleUpdate = true;
    }

    public TotemWoodType getWoodType() {
        return this.woodType;
    }

    public void setWoodType(TotemWoodType woodType) {
        this.woodType = Objects.requireNonNull(woodType);
        this.woodTypeLoc = woodType.getRegistryName();
        this.requestModelDataUpdate();
        this.setChanged();
    }

    public List<TotemCarving> getCarvingList() {
        return this.carvingList;
    }

    public boolean hasCarving(TotemCarving carving) {
        if (this.carvingSet == null) {
            this.carvingSet = Set.copyOf(this.carvingList);
        }
        return this.carvingSet.contains(carving);
    }

    public Multiset<TotemEffect> getTotemEffects() {
        return this.totemEffects;
    }

    public int getPoleSize() {
        return this.carvingList.size();
    }

    public int getCommonTotemEffectInterval() {
        return this.commonTotemEffectInterval;
    }

    public TotemState getTotemState() {
        return this.state;
    }

    void setTotemState(TotemState state) {
        if (state != this.state) {
            this.state = state;
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                this.setChanged();
                this.invalidateCapabilities();
            }
        }
    }

    public void resetTotemState() {
        this.state.resetTotemState();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("Wood", this.woodTypeLoc.toString());
        tag.putByte("State", this.state.getID());
        this.state.save(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.woodTypeLoc = Objects.requireNonNullElse(ResourceLocation.tryParse((String)tag.getString("Wood")), ModContent.oak.getId());
        Optional optWood = TotemicAPI.get().registry().woodTypes().getOptional(this.woodTypeLoc);
        if (optWood.isEmpty()) {
            Totemic.logger.warn("Unknown Totem Wood Type: '{}'", (Object)this.woodTypeLoc);
        }
        this.woodType = (TotemWoodType)optWood.orElseGet(ModContent.oak);
        this.requestModelDataUpdate();
        if (tag.contains("State", 1)) {
            byte id = tag.getByte("State");
            if (id != this.state.getID()) {
                this.state = TotemState.fromID(id, this);
            }
            this.state.load(tag, registries);
        } else {
            this.state = new StateTotemEffect(this);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(TotemPoleModelData.WOOD_TYPE_PROPERTY, (Object)this.woodType).build();
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(TotemicCapabilities.MUSIC_ACCEPTOR, ModBlockEntities.totem_base.get(), (totem, context) -> totem.state);
    }
}

