/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.block.DummyTipiBlock;
import pokefenn.totemic.init.ModBlocks;

public class TipiBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<TipiBlock> CODEC = TipiBlock.simpleCodec(TipiBlock::new);
    public static final BooleanProperty OCCUPIED = BedBlock.OCCUPIED;
    private static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    private static final VoxelShape VISUAL_SHAPE = Shapes.box((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)6.25, (double)2.0);

    public TipiBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return true;
    }

    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader levelReader, BlockPos pos, float orientation) {
        Direction facing = ((Direction)state.getValue((Property)FACING)).getOpposite();
        return Optional.of(new ServerPlayer.RespawnPosAngle(Vec3.upFromBottomCenterOf((Vec3i)pos, (double)0.0625), facing.toYRot()));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.canSetSpawn((Level)level)) {
            level.removeBlock(pos, false);
            this.removeDummyTipiBlocks(level, pos);
            Vec3 vec3 = pos.getCenter();
            level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        if (!level.canSeeSky(pos.above(6))) {
            player.displayClientMessage((Component)Component.translatable((String)"block.totemic.tipi.cantSleep"), true);
            return InteractionResult.SUCCESS;
        }
        player.startSleepInBed(pos).ifLeft(problem -> {
            if (problem.getMessage() != null) {
                player.displayClientMessage(problem.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.canPlaceTipi(ctx) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection()) : null;
    }

    private boolean canPlaceTipi(BlockPlaceContext ctx) {
        int y;
        BlockPos pos;
        Level level = ctx.getLevel();
        BlockState belowState = level.getBlockState((pos = ctx.getClickedPos()).below());
        if (!belowState.is(BlockTags.DIRT)) {
            return false;
        }
        if (!belowState.isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
            return false;
        }
        boolean radius = true;
        int middleHeight = 3;
        int totalHeight = 6;
        if (level.isOutsideBuildHeight(pos.getY() + 6 - 1)) {
            Player player = ctx.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.sendSystemMessage((Component)Component.translatable((String)"build.tooHigh", (Object[])new Object[]{level.getMaxBuildHeight() - 1}).withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        for (y = 0; y < 3; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.offset(x, y, z);
                    if (level.getBlockState(p).canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)p, (Direction)Direction.DOWN))) continue;
                    return false;
                }
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.offset(0, y, 0);
            if (level.getBlockState(p).canBeReplaced(BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)p, (Direction)Direction.DOWN))) continue;
            return false;
        }
        return true;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        int y;
        Direction facing = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockState dummyTipiState = ((DummyTipiBlock)((Object)ModBlocks.dummy_tipi.get())).defaultBlockState();
        for (y = 0; y < 2; ++y) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (dir == facing) continue;
                BlockPos p = pos.relative(dir).above(y);
                level.setBlock(p, dummyTipiState, 7);
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.above(y);
            level.setBlock(p, dummyTipiState, 7);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.removeDummyTipiBlocks(level, pos);
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        this.removeDummyTipiBlocks(level, pos);
        super.wasExploded(level, pos, explosion);
    }

    private void removeDummyTipiBlocks(Level level, BlockPos pos) {
        int y;
        BlockState airState = Blocks.AIR.defaultBlockState();
        for (y = 0; y < 2; ++y) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos p = pos.relative(dir).above(y);
                if (!level.getBlockState(p).is((Block)ModBlocks.dummy_tipi.get())) continue;
                level.setBlock(p, airState, 39);
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.above(y);
            if (!level.getBlockState(p).is((Block)ModBlocks.dummy_tipi.get())) continue;
            level.setBlock(p, airState, 39);
        }
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected VoxelShape getVisualShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return VISUAL_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, OCCUPIED});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

