/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.ceremony;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicInstrument;

public final class Ceremony {
    private int musicNeeded;
    private int maxStartupTime;
    private final Supplier<CeremonyInstance> factory;
    private List<MusicInstrument> selectors;
    @Nullable
    private String descriptionId;

    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, MusicInstrument selector1, MusicInstrument selector2) {
        this.musicNeeded = musicNeeded;
        this.maxStartupTime = maxStartupTime;
        this.factory = factory;
        this.selectors = List.of(selector1, selector2);
    }

    public Ceremony(int musicNeeded, int maxStartupTime, Supplier<CeremonyInstance> factory, Supplier<MusicInstrument> selector1, Supplier<MusicInstrument> selector2) {
        this(musicNeeded, maxStartupTime, factory, selector1.get(), selector2.get());
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"totemic.ceremony", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().ceremonies().getKey((Object)this);
    }

    public final ResourceKey<Ceremony> getResourceKey() {
        return (ResourceKey)TotemicAPI.get().registry().ceremonies().getResourceKey((Object)this).get();
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public int getMusicNeeded() {
        return this.musicNeeded;
    }

    public int getMaxStartupTime() {
        return this.maxStartupTime;
    }

    public int getAdjustedMaxStartupTime(Difficulty diff) {
        return (int)((double)this.getMaxStartupTime() * TotemicAPI.get().ceremony().getStartupTimeMultiplier(diff));
    }

    public CeremonyInstance createInstance() {
        return this.factory.get();
    }

    public List<MusicInstrument> getSelectors() {
        return this.selectors;
    }

    public Ceremony setMusicNeeded(int musicNeeded) {
        this.musicNeeded = musicNeeded;
        return this;
    }

    public Ceremony setMaxStartupTime(int maxStartupTime) {
        this.maxStartupTime = maxStartupTime;
        return this;
    }

    public Ceremony setSelectors(List<MusicInstrument> selectors) {
        if (selectors.size() < 2 || selectors.size() > 2) {
            throw new IllegalArgumentException("Invalid number of Ceremony selectors: " + selectors.size());
        }
        this.selectors = List.copyOf(selectors);
        return this;
    }
}

