/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api;

import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public final class TotemicEntityUtil {
    public static AABB getAABBAround(BlockPos pos, double range) {
        return TotemicEntityUtil.getAABBAround(pos, range, range);
    }

    public static AABB getAABBAround(BlockPos pos, double horizontalRange, double verticalRange) {
        return new AABB(pos).inflate(horizontalRange, verticalRange, horizontalRange);
    }

    public static BoundingBox getBoundingBoxAround(BlockPos pos, int range) {
        return TotemicEntityUtil.getBoundingBoxAround(pos, range, range);
    }

    public static BoundingBox getBoundingBoxAround(BlockPos pos, int horizontalRange, int verticalRange) {
        return BoundingBox.fromCorners((Vec3i)pos.offset(-horizontalRange, -verticalRange, -horizontalRange), (Vec3i)pos.offset(horizontalRange, verticalRange, horizontalRange));
    }

    public static Stream<? extends Player> getPlayersIn(Level level, AABB aabb) {
        return TotemicEntityUtil.getPlayersIn(level, aabb, EntitySelector.NO_SPECTATORS);
    }

    public static Stream<? extends Player> getPlayersIn(Level level, AABB aabb, Predicate<? super Player> filter) {
        level.getProfiler().incrementCounter("totemic.getPlayersIn");
        return level.players().stream().filter(player -> player.getBoundingBox().intersects(aabb) && filter.test((Player)player));
    }
}

