/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.client.ModModelLayers;
import pokefenn.totemic.handler.ClientInitHandlers;
import pokefenn.totemic.handler.ClientInteract;
import pokefenn.totemic.handler.ClientRenderHandler;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.item.MedicineBagItem;

@Mod(value="totemic", dist={Dist.CLIENT})
public final class ClientTotemicMod {
    public ClientTotemicMod(IEventBus modBus, ModContainer container) {
        modBus.addListener(this::clientSetup);
        modBus.register(ClientInitHandlers.class);
        modBus.register(ModModelLayers.class);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mod, parent) -> new ConfigurationScreen(mod, parent, (context, key, original) -> key.equals("customTotemWoodTypes") ? null : original)));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)ModBlocks.CEDAR_WOOD_TYPE);
            ResourceLocation pulling = ResourceLocation.withDefaultNamespace((String)"pulling");
            ResourceLocation pull = ResourceLocation.withDefaultNamespace((String)"pull");
            ItemStack bowStack = new ItemStack((ItemLike)Items.BOW);
            ItemProperties.register((Item)((Item)ModItems.baykok_bow.get()), (ResourceLocation)pulling, (ItemPropertyFunction)ItemProperties.getProperty((ItemStack)bowStack, (ResourceLocation)pulling));
            ItemProperties.register((Item)((Item)ModItems.baykok_bow.get()), (ResourceLocation)pull, (ItemPropertyFunction)ItemProperties.getProperty((ItemStack)bowStack, (ResourceLocation)pull));
            ItemPropertyFunction isOpenFunc = (stack, level, entity, seed) -> MedicineBagItem.isOpen(stack) ? 1.0f : 0.0f;
            ResourceLocation name = Totemic.resloc("open");
            ItemProperties.register((Item)((Item)ModItems.medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)isOpenFunc);
            ItemProperties.register((Item)((Item)ModItems.creative_medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)isOpenFunc);
        });
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.register(ClientInteract.class);
        eventBus.register(ClientRenderHandler.class);
    }
}

