/*
 * Decompiled with CFR 0.152.
 */
package ca.oliviermartinez.bedrockbreaker.mixin;

import ca.oliviermartinez.bedrockbreaker.BedrockBreaker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockBehaviourMixin {
    @Inject(method={"getDestroyProgress(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDestroySpeed(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos, CallbackInfoReturnable<Float> info) {
        if (player.getMainHandItem().is(BedrockBreaker.BEDROCK_BREAKER_ITEM)) {
            if (!blockState.is(Blocks.BEDROCK)) {
                info.setReturnValue((Object)Float.valueOf(0.0f));
                return;
            }
            CompoundTag tag = ((CustomData)player.getMainHandItem().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).getUnsafe();
            if (!tag.getBoolean("last_layer") && blockPos.getY() <= player.level().getMinBuildHeight()) {
                info.setReturnValue((Object)Float.valueOf(0.0f));
                return;
            }
            if (!tag.getBoolean("the_end") && player.level().dimensionType().effectsLocation().equals((Object)BuiltinDimensionTypes.END.location())) {
                info.setReturnValue((Object)Float.valueOf(0.0f));
                return;
            }
            info.setReturnValue((Object)Float.valueOf(player.getDestroySpeed(blockState) / 0.8f / 30.0f));
        }
    }
}

