/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs.node;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class ItemTagNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"lootjs", (String)"item_tag");
    private final ITooltipNode tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final TagKey<? extends ItemLike> tag;
    private final RangeValue count;
    private final float chance;
    private final boolean modified;

    public ItemTagNode(IServerUtils utils, TagKey<? extends ItemLike> entry, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions, boolean preserveCount) {
        this(utils, entry, chance, false, functions, conditions, preserveCount);
    }

    public ItemTagNode(IServerUtils utils, TagKey<? extends ItemLike> entry, float chance, boolean modified, List<LootItemFunction> functions, List<LootItemCondition> conditions, boolean preserveCount) {
        this.conditions = conditions;
        this.functions = functions;
        this.tag = entry;
        this.chance = chance;
        this.modified = modified;
        if (preserveCount) {
            this.tooltip = ItemTagNode.getItemTooltip(utils, chance, functions, conditions);
            this.count = ItemTagNode.getCount(utils, 1, functions).get(null).get(0);
        } else {
            this.tooltip = ItemTagNode.getItemTooltip(utils, chance, Collections.emptyList(), Collections.emptyList());
            this.count = ItemTagNode.getCount(utils, 1, Collections.emptyList()).get(null).get(0);
        }
    }

    public ItemTagNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)buf.readResourceLocation());
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue((FriendlyByteBuf)buf);
        this.modified = buf.readBoolean();
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.right(this.tag);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    @NotNull
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.tag.location());
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode((FriendlyByteBuf)buf);
        buf.writeBoolean(this.modified);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    private static ITooltipNode getItemTooltip(IServerUtils utils, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap = NodeUtils.getEnchantedChance(utils, conditions, chance);
        Map<Holder<Enchantment>, Map<Integer, RangeValue>> countMap = ItemTagNode.getCount(utils, 1, functions);
        return EntryTooltipUtils.getTooltip(utils, 0, chanceMap, countMap, functions, conditions);
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getCount(IServerUtils utils, int baseCount, List<LootItemFunction> functions) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> count = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue(baseCount)));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }
}

