/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs;

import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.LootTableFilter;
import com.almostreliable.lootjs.loot.modifier.LootModifier;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.lootjs.AbstractLootModifier;
import com.yanny.ali.lootjs.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;

public class TableLootModifier
extends AbstractLootModifier<ResourceLocation> {
    private final List<Predicate<ResourceLocation>> predicates = new ArrayList<Predicate<ResourceLocation>>();

    public TableLootModifier(IServerUtils utils, LootModifier modifier, LootModifier.TableFiltered tableFiltered) {
        super(utils, modifier);
        for (LootTableFilter filter : tableFiltered.filters()) {
            IdFilter idFilter;
            if (filter instanceof LootTableFilter.ByIdFilter) {
                LootTableFilter.ByIdFilter byIdFilter = (LootTableFilter.ByIdFilter)filter;
                IdFilter idFilter2 = idFilter = byIdFilter.filter();
                this.predicates.add((Predicate<ResourceLocation>)idFilter2);
                continue;
            }
            if (!(filter instanceof LootTableFilter.ByLootType)) continue;
            LootTableFilter.ByLootType byLootType = (LootTableFilter.ByLootType)filter;
            try {
                IdFilter type = idFilter = byLootType.type();
                this.predicates.add(Utils.typePredicate((LootType)type));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    public TableLootModifier(IServerUtils utils, LootModifier modifier, LootModifier.TypeFiltered typeFiltered) {
        super(utils, modifier);
        for (LootType type : typeFiltered.types()) {
            this.predicates.add(Utils.typePredicate(type));
        }
    }

    @Override
    public boolean predicate(ResourceLocation value) {
        return this.predicates.stream().anyMatch(p -> p.test(value));
    }

    @Override
    public ILootModifier.IType<ResourceLocation> getType() {
        return ILootModifier.IType.LOOT_TABLE;
    }
}

