/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.jei.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.jei.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.jei.compatibility.jei.RecipeHolder;
import com.yanny.ali.plugin.client.widget.trades.TradeWidget;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class JeiTradeLoot
extends JeiBaseLoot<TradeLootType, ResourceLocation> {
    public JeiTradeLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<TradeLootType>> recipeType, LootCategory<ResourceLocation> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder builder, TradeLootType recipe) {
        String key = recipe.id().equals("empty") ? "entity.minecraft.wandering_trader" : "entity.minecraft.villager." + recipe.id();
        String id = recipe.id().equals("empty") ? "wandering_trader" : recipe.id();
        Component text = GenericUtils.ellipsis(key, id, 162);
        MutableComponent fullText = Component.translatableWithFallback((String)key, (String)id);
        Rect rect = new Rect(0, 0, 162, 8);
        return new Pair(List.of(this.createTextWidget(text, 0, false), new TooltipWidget((Component)fullText, rect)), List.of());
    }

    @Override
    int getYOffset(TradeLootType recipe) {
        return 10;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new TradeWidget(utils, entry, rect, maxWidth);
    }

    private record TooltipWidget(Component component, Rect rect) implements IRecipeWidget
    {
        @NotNull
        public ScreenPosition getPosition() {
            return new ScreenPosition(this.rect().x(), this.rect.y());
        }

        public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
            if (this.rect.contains((int)mouseX, (int)mouseY)) {
                tooltip.add((FormattedText)this.component);
            }
        }
    }
}

