/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.emi.compatibility.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yanny.ali.mixin.MixinBushBlock;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EmiBlockSlotWidget
extends SlotWidget {
    private final ClientLevel level;
    private final BlockState blockState;
    private final Block block;
    private final boolean isPlant;

    public EmiBlockSlotWidget(Block block, int x, int y) {
        super((EmiIngredient)EmiStack.of((ItemLike)block), x, y);
        this.block = block;
        this.blockState = block.defaultBlockState();
        this.isPlant = block instanceof BushBlock;
        this.level = Minecraft.getInstance().level;
        this.large(true);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.drawBackground(guiGraphics, mouseX, mouseY, delta);
        this.drawOverlay(guiGraphics, mouseX, mouseY, delta);
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.x, (float)this.y, 0.0f);
        if (this.isPlant) {
            MixinBushBlock bushBlock;
            poseStack.translate(19.0, 12.5, 300.0);
            poseStack.scale(9.0f, -9.0f, 9.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
            blockRenderer.renderSingleBlock(this.blockState, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
            BlockState farmland = Blocks.FARMLAND.defaultBlockState();
            Block block = this.block;
            BlockState base = block instanceof MixinBushBlock && (bushBlock = (MixinBushBlock)block).invokeMayPlaceOn(farmland, (BlockGetter)this.level, BlockPos.ZERO) ? farmland : Blocks.GRASS_BLOCK.defaultBlockState();
            poseStack.translate(0.0f, -1.0f, 0.0f);
            blockRenderer.renderSingleBlock(base, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
        } else {
            poseStack.translate(25.5, 21.0, 100.0);
            poseStack.scale(18.0f, -18.0f, 18.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(225.0f));
            blockRenderer.renderSingleBlock(this.blockState, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.translate(0.0f, -1.0f, 0.0f);
        }
        poseStack.popPose();
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        if (this.block.asItem() == Items.AIR) {
            return List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)this.block.getDescriptionId()).getVisualOrderText()));
        }
        return super.getTooltip(mouseX, mouseY);
    }
}

